/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.index.es;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.AnalyzeRequest;
import org.elasticsearch.client.indices.AnalyzeResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.WrapperQueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class EsRestClient
implements InitializingBean {
    private static EsRestClient instance;
    private RestHighLevelClient client;
    @Value(value="${es.url}")
    private String serverUrl;
    @Value(value="${es.protocol}")
    private String serverProtocol;
    @Value(value="${es.host}")
    private String serverHost;
    @Value(value="${es.port}")
    private String serverPort;
    @Value(value="${es.username}")
    private String username;
    @Value(value="${es.password}")
    private String password;
    private boolean activated = false;
    @Value(value="${kb.url}")
    private String dashboardAppUrl;
    public static final String ROUTING_KEY = "101";

    public static EsRestClient get() {
        return instance;
    }

    public RestHighLevelClient getClient() throws Exception {
        return this.client;
    }

    public String getDashboardAppUrl() {
        return this.dashboardAppUrl;
    }

    public void setDashboardAppUrl(String dashboardAppUrl) {
        this.dashboardAppUrl = dashboardAppUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotEmpty((String)this.serverUrl)) {
            RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.serverHost, Integer.parseInt(this.serverPort), this.serverProtocol)});
            if (this.serverUrl.startsWith("https://")) {
                final SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                        return true;
                    }
                }).build();
                NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
                SSLIOSessionStrategy httpsIOSessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)hostnameVerifier);
                if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                    builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                        final /* synthetic */ CredentialsProvider val$credentialsProvider;
                        {
                            this.val$credentialsProvider = credentialsProvider;
                        }

                        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                            return httpClientBuilder.setSSLContext(sslContext).setDefaultCredentialsProvider(this.val$credentialsProvider);
                        }
                    });
                } else {
                    builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                            return httpClientBuilder.setSSLContext(sslContext);
                        }
                    });
                }
            } else if (StringUtils.isNotEmpty((String)this.username) && StringUtils.isNotEmpty((String)this.password)) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
                builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
            }
            this.client = new RestHighLevelClient(builder);
            Class<EsRestClient> clazz = EsRestClient.class;
            synchronized (EsRestClient.class) {
                instance = this;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.activated = true;
            }
        } else {
            Log.debug((String)"geonetwork.index", (Object)String.format("No Elasticsearch URL defined '%s'. Check configuration.", this.serverUrl));
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public EsRestClient setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public EsRestClient setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public EsRestClient setPassword(String password) {
        this.password = password;
        return this;
    }

    public BulkResponse bulkRequest(String index, Map<String, String> docs) throws IOException {
        if (!this.activated) {
            throw new IOException("Index not yet activated.");
        }
        BulkRequest request = new BulkRequest();
        request.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        for (Map.Entry<String, String> entry : docs.entrySet()) {
            request.add(new IndexRequest(index).id(entry.getKey()).source(entry.getValue(), XContentType.JSON));
        }
        try {
            return this.client.bulk(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, int from, int size) throws Exception {
        return this.query(index, luceneQuery, filterQuery, includedFields, from, size, null);
    }

    public SearchResponse query(String index, String luceneQuery, String filterQuery, Set<String> includedFields, int from, int size, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        QueryStringQueryBuilder query = QueryBuilders.queryStringQuery((String)luceneQuery);
        QueryStringQueryBuilder filter = null;
        if (StringUtils.isNotEmpty((String)filterQuery)) {
            filter = QueryBuilders.queryStringQuery((String)filterQuery);
        }
        return this.query(index, (QueryBuilder)query, (QueryBuilder)filter, includedFields, from, size, sort);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, QueryBuilder postFilterBuilder, Set<String> includedFields, int from, int size) throws Exception {
        return this.query(index, jsonQuery, postFilterBuilder, includedFields, from, size, null);
    }

    public SearchResponse query(String index, JsonNode jsonQuery, QueryBuilder postFilterBuilder, Set<String> includedFields, int from, int size, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        WrapperQueryBuilder query = QueryBuilders.wrapperQuery((String)String.valueOf(jsonQuery));
        return this.query(index, (QueryBuilder)query, postFilterBuilder, includedFields, from, size, sort);
    }

    public SearchResponse query(String index, QueryBuilder queryBuilder, QueryBuilder postFilterBuilder, Set<String> includedFields, int from, int size, List<SortBuilder<FieldSortBuilder>> sort) throws Exception {
        if (!this.activated) {
            return null;
        }
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{index});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        searchSourceBuilder.fetchSource(includedFields.toArray(new String[includedFields.size()]), null);
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(size);
        if (postFilterBuilder != null) {
            searchSourceBuilder.postFilter(postFilterBuilder);
        }
        if (sort != null && !sort.isEmpty()) {
            sort.forEach(s -> searchSourceBuilder.sort(s));
        }
        searchRequest.source(searchSourceBuilder);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            if (searchResponse.status().getStatus() == 200) {
                return searchResponse;
            }
            throw new IOException(String.format("Error during querying index. Errors is '%s'.", searchResponse.status().toString()));
        }
        catch (ElasticsearchStatusException esException) {
            Throwable[] suppressed = esException.getSuppressed();
            if (suppressed.length > 0 && suppressed[0] instanceof ResponseException) {
                ResponseException re = (ResponseException)suppressed[0];
                Log.error((String)"geonetwork.index", (Object)String.format("Error during querying index. %s", re.getMessage()));
            }
            throw esException;
        }
    }

    public String deleteByQuery(String index, String query) throws Exception {
        if (!this.activated) {
            return "";
        }
        DeleteByQueryRequest request = new DeleteByQueryRequest();
        request.setRefresh(true);
        request.indices(new String[]{index});
        request.setQuery((QueryBuilder)new QueryStringQueryBuilder(query));
        BulkByScrollResponse deleteByQueryResponse = this.client.deleteByQuery(request, RequestOptions.DEFAULT);
        if (deleteByQueryResponse.getStatus().getDeleted() >= 0L) {
            return String.format("Record removed. %s.", deleteByQueryResponse.getStatus().getDeleted());
        }
        throw new IOException(String.format("Error during removal. Errors is '%s'.", deleteByQueryResponse.getStatus().getReasonCancelled()));
    }

    public Map<String, Object> getDocument(String index, String id) throws Exception {
        if (!this.activated) {
            return null;
        }
        GetRequest request = ((GetRequest)new GetRequest().index(index)).id(id);
        return this.client.get(request, RequestOptions.DEFAULT).getSourceAsMap();
    }

    public Map<String, String> getFieldsValues(String index, String id, Set<String> fields) throws IOException {
        if (!this.activated) {
            return null;
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>(fields.size());
        try {
            String query = String.format("_id:\"%s\"", id);
            SearchResponse searchResponse = this.query(index, query, null, fields, 0, 1, null);
            if (searchResponse.status().getStatus() == 200) {
                if (searchResponse.getHits().getTotalHits().value == 0L) {
                    return fieldValues;
                }
                if (searchResponse.getHits().getTotalHits().value != 1L) {
                    throw new IOException(String.format("Your query '%s' returned more than one record, %d in fact. Can't retrieve field values for more than one record.", query, searchResponse.getHits().getTotalHits()));
                }
            } else {
                throw new IOException(String.format("Error during fields value retrieval. Status is '%s'.", searchResponse.status().getStatus()));
            }
            SearchHit[] hits = searchResponse.getHits().getHits();
            fields.forEach(f -> {
                Object o = hits[0].getSourceAsMap().get(f);
                if (o instanceof String) {
                    fieldValues.put((String)f, (String)o);
                } else if (o instanceof HashMap && f.endsWith("Object")) {
                    fieldValues.put((String)f, (String)((HashMap)o).get("default"));
                }
            });
        }
        catch (Exception e) {
            throw new IOException(String.format("Error during fields value retrieval. Errors is '%s'.", e.getMessage()));
        }
        return fieldValues;
    }

    public static String analyzeField(String collection, String analyzer, String fieldValue) {
        AnalyzeRequest request = AnalyzeRequest.withIndexAnalyzer((String)collection, (String)analyzer, (String[])new String[]{fieldValue.replace(",", "")});
        String analyzedValue = "";
        try {
            AnalyzeResponse response = EsRestClient.get().client.indices().analyze(request, RequestOptions.DEFAULT);
            List tokens = response.getTokens();
            if (tokens.size() == 1) {
                String type = ((AnalyzeResponse.AnalyzeToken)tokens.get(0)).getType();
                if ("SYNONYM".equals(type) || "word".equals(type)) {
                    return ((AnalyzeResponse.AnalyzeToken)tokens.get(0)).getTerm();
                }
                return "";
            }
            return "";
        }
        catch (Exception ex) {
            return "";
        }
    }

    protected void finalize() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getServerStatus() throws Exception {
        ClusterHealthRequest request = new ClusterHealthRequest();
        ClusterHealthResponse response = this.client.cluster().health(request, RequestOptions.DEFAULT);
        return response.getStatus().toString();
    }
}

