/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.elasticstack.compute;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.domain.Location;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.elasticstack.ElasticStackApi;
import org.jclouds.elasticstack.domain.Device;
import org.jclouds.elasticstack.domain.Drive;
import org.jclouds.elasticstack.domain.DriveInfo;
import org.jclouds.elasticstack.domain.ImageConversionType;
import org.jclouds.elasticstack.domain.Server;
import org.jclouds.elasticstack.domain.ServerInfo;
import org.jclouds.elasticstack.domain.ServerStatus;
import org.jclouds.elasticstack.domain.WellKnownImage;
import org.jclouds.elasticstack.util.Servers;
import org.jclouds.logging.Logger;

@Singleton
public class ElasticStackComputeServiceAdapter
implements ComputeServiceAdapter<ServerInfo, Hardware, DriveInfo, Location> {
    private final ElasticStackApi client;
    private final Predicate<DriveInfo> driveNotClaimed;
    private final Supplier<Map<String, WellKnownImage>> preinstalledImages;
    private final LoadingCache<String, DriveInfo> cache;
    private final String defaultVncPassword;
    private final ListeningExecutorService userExecutor;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    public ElasticStackComputeServiceAdapter(ElasticStackApi client, Predicate<DriveInfo> driveNotClaimed, @Memoized Supplier<Map<String, WellKnownImage>> preinstalledImages, LoadingCache<String, DriveInfo> cache, @Named(value="jclouds.elasticstack.vnc-password") String defaultVncPassword, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.client = (ElasticStackApi)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.driveNotClaimed = (Predicate)Preconditions.checkNotNull(driveNotClaimed, (Object)"driveNotClaimed");
        this.preinstalledImages = (Supplier)Preconditions.checkNotNull(preinstalledImages, (Object)"preinstalledImages");
        this.cache = (LoadingCache)Preconditions.checkNotNull(cache, (Object)"cache");
        this.defaultVncPassword = (String)Preconditions.checkNotNull((Object)defaultVncPassword, (Object)"defaultVncPassword");
        Preconditions.checkArgument((defaultVncPassword.length() <= 8 ? 1 : 0) != 0, (Object)"vnc passwords should be less that 8 characters!");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
    }

    public ComputeServiceAdapter.NodeAndInitialCredentials<ServerInfo> createNodeWithGroupEncodedIntoName(String tag, String name, Template template) {
        long bootSize = (long)(((Volume)template.getHardware().getVolumes().get(0)).getSize().floatValue() * 1024.0f * 1024.0f * 1024.0f);
        this.logger.debug(">> creating boot drive bytes(%d)", new Object[]{bootSize});
        DriveInfo drive = this.client.createDrive(new Drive.Builder().name(template.getImage().getId()).size(bootSize).build());
        this.logger.debug("<< drive (%s)", new Object[]{drive});
        boolean success = this.driveNotClaimed.apply((Object)drive);
        if (!success) {
            this.client.destroyDrive(drive.getUuid());
            throw new IllegalStateException(String.format("could not create drive %s in time!", drive));
        }
        this.logger.debug(">> imaging boot drive source(%s)", new Object[]{template.getImage().getId()});
        try {
            this.client.imageDrive(template.getImage().getId(), drive.getUuid(), ImageConversionType.GUNZIP);
        }
        catch (IllegalStateException ex) {
            this.logger.debug(">> could not image drive(%s). Cleaning up resources. [%s]", new Object[]{drive.getUuid(), ex.getMessage()});
            this.client.destroyDrive(drive.getUuid());
            throw ex;
        }
        boolean ready = this.driveNotClaimed.apply((Object)drive);
        if (!ready) {
            this.client.destroyDrive(drive.getUuid());
            throw new IllegalStateException(String.format("could not image drive %s in time!", drive));
        }
        this.logger.debug("<< imaged (%s)", new Object[]{drive});
        template.getOptions().userMetadata("jclouds-group", tag);
        Server toCreate = ((Server.Builder)((Server.Builder)Servers.small(name, drive.getUuid(), this.defaultVncPassword).mem(template.getHardware().getRam()).cpu((int)((Processor)template.getHardware().getProcessors().get(0)).getSpeed()).tags((Iterable)template.getOptions().getTags())).userMetadata(template.getOptions().getUserMetadata())).build();
        ServerInfo from = this.client.createServer(toCreate);
        this.client.startServer(from.getUuid());
        from = this.client.getServerInfo(from.getUuid());
        return new ComputeServiceAdapter.NodeAndInitialCredentials((Object)from, from.getUuid(), LoginCredentials.builder().password(this.defaultVncPassword).build());
    }

    public Iterable<Hardware> listHardwareProfiles() {
        ImmutableSet.Builder hardware = ImmutableSet.builder();
        for (double cpu : new double[]{1000.0, 5000.0, 10000.0, 20000.0}) {
            for (int ram : new int[]{512, 1024, 2048, 4096, 8192}) {
                final float size = (float)cpu / 1000.0f;
                String id = String.format("cpu=%f,ram=%s,disk=%f", cpu, ram, Float.valueOf(size));
                hardware.add((Object)new HardwareBuilder().supportsImage((Predicate)new Predicate<Image>(){

                    public boolean apply(Image input) {
                        String toParse = (String)input.getUserMetadata().get("size");
                        return toParse != null && Float.parseFloat(toParse) <= size;
                    }

                    public String toString() {
                        return "sizeLessThanOrEqual(" + size + ")";
                    }
                }).ids(id).ram(ram).processors((Iterable)ImmutableList.of((Object)new Processor(1.0, cpu))).hypervisor("kvm").volumes((Iterable)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(size), true, true))).build());
            }
        }
        return hardware.build();
    }

    public Iterable<DriveInfo> listImages() {
        return FluentIterable.from((Iterable)FutureIterables.transformParallel(((Map)this.preinstalledImages.get()).keySet(), (Function)new Function<String, ListenableFuture<? extends DriveInfo>>(){

            public ListenableFuture<? extends DriveInfo> apply(String input) {
                try {
                    return Futures.immediateFuture((Object)ElasticStackComputeServiceAdapter.this.cache.getUnchecked((Object)input));
                }
                catch (CacheLoader.InvalidCacheLoadException e) {
                    ElasticStackComputeServiceAdapter.this.logger.debug("drive %s not found", new Object[]{input});
                }
                catch (UncheckedExecutionException e) {
                    ElasticStackComputeServiceAdapter.this.logger.warn((Throwable)e, "error finding drive %s: %s", new Object[]{input, e.getMessage()});
                }
                return Futures.immediateFuture(null);
            }

            public String toString() {
                return "seedDriveCache()";
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)"drives")).filter(Predicates.notNull());
    }

    public Iterable<ServerInfo> listNodes() {
        return this.client.listServerInfo();
    }

    public Iterable<ServerInfo> listNodesByIds(final Iterable<String> ids) {
        return Iterables.filter(this.listNodes(), (Predicate)new Predicate<ServerInfo>(){

            public boolean apply(ServerInfo server) {
                return Iterables.contains((Iterable)ids, (Object)server.getUuid());
            }
        });
    }

    public Iterable<Location> listLocations() {
        return ImmutableSet.of();
    }

    public ServerInfo getNode(String id) {
        return this.client.getServerInfo(id);
    }

    public DriveInfo getImage(String id) {
        return this.client.getDriveInfo(id);
    }

    public void destroyNode(String id) {
        ServerInfo server = this.getNode(id);
        if (server != null) {
            if (server.getStatus() != ServerStatus.STOPPED) {
                this.client.stopServer(id);
            }
            this.client.destroyServer(id);
            for (Device device : server.getDevices().values()) {
                this.client.destroyDrive(device.getDriveUuid());
            }
        }
    }

    public void rebootNode(String id) {
        this.client.resetServer(id);
    }

    public void resumeNode(String id) {
        this.client.startServer(id);
    }

    public void suspendNode(String id) {
        this.client.stopServer(id);
    }
}

