/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.binder.server;

import org.jclouds.profitbricks.binder.BaseProfitBricksRequestBinder;
import org.jclouds.profitbricks.domain.Server;

public class CreateServerRequestBinder
extends BaseProfitBricksRequestBinder<Server.Request.CreatePayload> {
    protected final StringBuilder requestBuilder = new StringBuilder(512);

    CreateServerRequestBinder() {
        super("server");
    }

    @Override
    protected String createPayload(Server.Request.CreatePayload payload) {
        this.requestBuilder.append("<ws:createServer>").append("<request>").append(String.format("<dataCenterId>%s</dataCenterId>", payload.dataCenterId())).append(String.format("<cores>%s</cores>", payload.cores())).append(String.format("<ram>%s</ram>", payload.ram())).append(CreateServerRequestBinder.formatIfNotEmpty("<serverName>%s</serverName>", payload.name())).append(CreateServerRequestBinder.formatIfNotEmpty("<bootFromStorageId>%s</bootFromStorageId>", payload.bootFromStorageId())).append(CreateServerRequestBinder.formatIfNotEmpty("<bootFromImageId>%s</bootFromImageId>", payload.bootFromImageId())).append(CreateServerRequestBinder.formatIfNotEmpty("<internetAccess>%s</internetAccess>", payload.hasInternetAccess())).append(CreateServerRequestBinder.formatIfNotEmpty("<lanId>%s</lanId>", payload.lanId())).append(CreateServerRequestBinder.formatIfNotEmpty("<osType>%s</osType>", (Object)payload.osType())).append(CreateServerRequestBinder.formatIfNotEmpty("<availabilityZone>%s</availabilityZone>", (Object)payload.availabilityZone())).append(CreateServerRequestBinder.formatIfNotEmpty("<cpuHotPlug>%s</cpuHotPlug>", payload.isCpuHotPlug())).append(CreateServerRequestBinder.formatIfNotEmpty("<ramHotPlug>%s</ramHotPlug>", payload.isRamHotPlug())).append(CreateServerRequestBinder.formatIfNotEmpty("<nicHotPlug>%s</nicHotPlug>", payload.isNicHotPlug())).append(CreateServerRequestBinder.formatIfNotEmpty("<nicHotUnPlug>%s</nicHotUnPlug>", payload.isNicHotUnPlug())).append(CreateServerRequestBinder.formatIfNotEmpty("<discVirtioHotPlug>%s</discVirtioHotPlug>", payload.isDiscVirtioHotPlug())).append(CreateServerRequestBinder.formatIfNotEmpty("<discVirtioHotUnPlug>%s</discVirtioHotUnPlug>", payload.isDiscVirtioHotUnPlug())).append("</request>").append("</ws:createServer>");
        return this.requestBuilder.toString();
    }
}

