/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers.vector;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import java.awt.geom.AffineTransform;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.map.renderers.vector.GeometriesRenderer;
import org.mapfish.print.map.renderers.vector.LineStringRenderer;
import org.mapfish.print.utils.PJsonObject;

class PolygonRenderer
extends GeometriesRenderer<Polygon> {
    PolygonRenderer() {
    }

    protected static void applyStyle(RenderingContext context, PdfContentByte dc, PJsonObject style, PdfGState state) {
        if (style == null) {
            return;
        }
        LineStringRenderer.applyStyle(context, dc, style, state);
        if (style.optString("fillColor") != null) {
            dc.setColorFill(ColorWrapper.convertColor(style.getString("fillColor")));
        }
        if (style.optString("fillOpacity") != null) {
            state.setFillOpacity(style.getFloat("fillOpacity"));
        }
    }

    @Override
    protected void renderImpl(RenderingContext context, PdfContentByte dc, PJsonObject style, Polygon geometry, AffineTransform affineTransform) {
        PdfGState state = new PdfGState();
        PolygonRenderer.applyStyle(context, dc, style, state);
        dc.setGState(state);
        LinearRing ring = geometry.getExteriorRing();
        this.renderRing(dc, (LineString)ring, affineTransform);
        for (int i = 0; i < geometry.getNumInteriorRing(); ++i) {
            this.renderRing(dc, (LineString)geometry.getInteriorRingN(i), affineTransform);
        }
        this.renderStrokeAndFill(dc, style.optBool("stroke", true), style.optBool("fill", true));
    }

    private void renderRing(PdfContentByte dc, LineString ring, AffineTransform affineTransform) {
        Coordinate[] coords = ring.getCoordinates();
        if (coords.length < 3) {
            return;
        }
        Coordinate coord = (Coordinate)coords[0].clone();
        PolygonRenderer.transformCoordinate(coord, affineTransform);
        dc.moveTo((float)coord.x, (float)coord.y);
        for (int i = 1; i < coords.length - 1; ++i) {
            coord = (Coordinate)coords[i].clone();
            PolygonRenderer.transformCoordinate(coord, affineTransform);
            dc.lineTo((float)coord.x, (float)coord.y);
        }
        dc.closePath();
    }

    private void renderStrokeAndFill(PdfContentByte dc, boolean stroke, boolean fill) {
        if (stroke && fill) {
            dc.eoFillStroke();
        } else if (stroke) {
            dc.stroke();
        } else if (fill) {
            dc.eoFill();
        }
    }
}

