/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.renderers.vector;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGState;
import java.awt.geom.AffineTransform;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.map.renderers.vector.GeometriesRenderer;
import org.mapfish.print.utils.PJsonObject;

public class LineStringRenderer
extends GeometriesRenderer<LineString> {
    protected static void applyStyle(RenderingContext context, PdfContentByte dc, PJsonObject style, PdfGState state) {
        String dashStyle;
        String linejoin;
        if (style == null) {
            return;
        }
        if (style.optString("strokeColor") != null) {
            dc.setColorStroke(ColorWrapper.convertColor(style.getString("strokeColor")));
        }
        if (style.optString("strokeOpacity") != null) {
            state.setStrokeOpacity(style.getFloat("strokeOpacity"));
        }
        float width = style.optFloat("strokeWidth", 1.0f).floatValue() * context.getStyleFactor();
        dc.setLineWidth(width);
        String linecap = style.optString("strokeLinecap");
        if (linecap != null) {
            if (linecap.equalsIgnoreCase("butt")) {
                dc.setLineCap(0);
            } else if (linecap.equalsIgnoreCase("round")) {
                dc.setLineCap(1);
            } else if (linecap.equalsIgnoreCase("square")) {
                dc.setLineCap(2);
            } else {
                throw new InvalidValueException("strokeLinecap", linecap);
            }
        }
        if ((linejoin = style.optString("strokeLinejoin")) != null) {
            if (linejoin.equalsIgnoreCase("bevel")) {
                dc.setLineJoin(2);
            } else if (linejoin.equalsIgnoreCase("miter")) {
                dc.setLineJoin(0);
            } else if (linejoin.equalsIgnoreCase("round")) {
                dc.setLineJoin(1);
            } else {
                throw new InvalidValueException("strokeLinejoin", linejoin);
            }
        }
        if ((dashStyle = style.optString("strokeDashstyle")) != null) {
            if (dashStyle.equalsIgnoreCase("dot")) {
                float[] def = new float[]{0.1f, 2.0f * width};
                dc.setLineDash(def, 0.0f);
            } else if (dashStyle.equalsIgnoreCase("dash")) {
                float[] def = new float[]{2.0f * width, 2.0f * width};
                dc.setLineDash(def, 0.0f);
            } else if (dashStyle.equalsIgnoreCase("dashdot")) {
                float[] def = new float[]{3.0f * width, 2.0f * width, 0.1f, 2.0f * width};
                dc.setLineDash(def, 0.0f);
            } else if (dashStyle.equalsIgnoreCase("longdash")) {
                float[] def = new float[]{4.0f * width, 2.0f * width};
                dc.setLineDash(def, 0.0f);
            } else if (dashStyle.equalsIgnoreCase("longdashdot")) {
                float[] def = new float[]{5.0f * width, 2.0f * width, 0.1f, 2.0f * width};
                dc.setLineDash(def, 0.0f);
            } else if (!dashStyle.equalsIgnoreCase("solid")) {
                if (dashStyle.contains(" ")) {
                    try {
                        String[] x = dashStyle.split(" ");
                        if (x.length > 1) {
                            float[] def = new float[x.length];
                            for (int i = 0; i < x.length; ++i) {
                                def[i] = Float.parseFloat(x[i]);
                            }
                            dc.setLineDash(def, 0.0f);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else {
                    throw new InvalidValueException("strokeDashstyle", dashStyle);
                }
            }
        }
    }

    @Override
    protected void renderImpl(RenderingContext context, PdfContentByte dc, PJsonObject style, LineString geometry, AffineTransform affineTransform) {
        PdfGState state = new PdfGState();
        LineStringRenderer.applyStyle(context, dc, style, state);
        dc.setGState(state);
        Coordinate[] coords = geometry.getCoordinates();
        if (coords.length < 2) {
            return;
        }
        Coordinate coord = (Coordinate)coords[0].clone();
        LineStringRenderer.transformCoordinate(coord, affineTransform);
        dc.moveTo((float)coord.x, (float)coord.y);
        for (int i = 1; i < coords.length; ++i) {
            coord = (Coordinate)coords[i].clone();
            LineStringRenderer.transformCoordinate(coord, affineTransform);
            dc.lineTo((float)coord.x, (float)coord.y);
        }
        if (style.optBool("stroke", true)) {
            dc.stroke();
        }
    }
}

