/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.util.Collections;
import java.util.List;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.i18n.Vocabulary;
import org.geotools.renderer.lite.gridcoverage2d.BaseCoverageProcessingNode;
import org.geotools.renderer.lite.gridcoverage2d.CoverageProcessingNode;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.opengis.util.InternationalString;

class RootNode
extends BaseCoverageProcessingNode
implements CoverageProcessingNode {
    private GridCoverage2D sourceCoverage;

    @Override
    public InternationalString getName() {
        return Vocabulary.formatInternational(9);
    }

    public RootNode(GridCoverage2D coverage) {
        this(coverage, null);
    }

    public RootNode(GridCoverage2D coverage, Hints hints) {
        super(-1, hints, (InternationalString)SimpleInternationalString.wrap((CharSequence)"RootNode"), (InternationalString)SimpleInternationalString.wrap((CharSequence)"Root node which does not have sources but simply wraps a GridCoverage2D"));
        RootNode.ensureNotNull(coverage, "GridCoverage2D");
        this.sourceCoverage = coverage;
    }

    @Override
    public boolean addSource(CoverageProcessingNode source) {
        throw new UnsupportedOperationException(Errors.format(15, "addSource(CoverageProcessingNode)"));
    }

    @Override
    public CoverageProcessingNode getSource(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<CoverageProcessingNode> getSources() {
        return Collections.emptyList();
    }

    @Override
    public void dispose(boolean force) {
        super.dispose(force);
        this.sourceCoverage.dispose(force);
    }

    protected GridCoverage2D execute() {
        return this.sourceCoverage;
    }
}

