/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.geotools.renderer.label.LabelCacheItem;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.quadtree.Quadtree;

public class LabelIndex {
    Quadtree index = new Quadtree();

    public boolean labelsWithinDistance(Rectangle2D bounds, double distance) {
        if (distance < 0.0) {
            return false;
        }
        final Envelope e = this.toEnvelope(bounds);
        e.expandBy(distance);
        final AtomicBoolean intersectionFound = new AtomicBoolean(false);
        this.index.query(e, new ItemVisitor(){

            public void visitItem(Object o) {
                if (intersectionFound.get()) {
                    return;
                }
                InterferenceItem item = (InterferenceItem)o;
                if (item.env.intersects(e)) {
                    intersectionFound.set(true);
                }
            }
        });
        return intersectionFound.get();
    }

    public void addLabel(LabelCacheItem item, Rectangle2D bounds) {
        Envelope e = this.toEnvelope(bounds);
        this.index.insert(e, (Object)new InterferenceItem(e, item));
    }

    private Envelope toEnvelope(Rectangle2D bounds) {
        return new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
    }

    public void reserveArea(List<Rectangle2D> reserved) {
        for (Rectangle2D area : reserved) {
            Envelope env = this.toEnvelope(area);
            InterferenceItem item = new InterferenceItem(env, null);
            this.index.insert(env, (Object)item);
        }
    }

    static class InterferenceItem {
        Envelope env;
        LabelCacheItem item;

        public InterferenceItem(Envelope env, LabelCacheItem item) {
            this.env = env;
            this.item = item;
        }
    }
}

