/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.v1_0;

import java.util.Objects;
import java.util.StringJoiner;

public final class DistanceUnits {
    private final double distance;
    private final String units;

    public static DistanceUnits of(double distance, String units) {
        return new DistanceUnits(distance, units);
    }

    private DistanceUnits(double distance, String units) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("distance must be >= 0");
        }
        if (units == null) {
            throw new IllegalArgumentException("units must not be null");
        }
        this.distance = distance;
        this.units = units;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getUnits() {
        return this.units;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistanceUnits that = (DistanceUnits)o;
        return Double.compare(that.distance, this.distance) == 0 && Objects.equals(this.units, that.units);
    }

    public int hashCode() {
        return Objects.hash(this.distance, this.units);
    }

    public String toString() {
        return new StringJoiner(", ", DistanceUnits.class.getSimpleName() + "[", "]").add("distance=" + this.distance).add("units='" + this.units + "'").toString();
    }
}

