/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.webdav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteRetriever;
import org.fao.geonet.kernel.harvest.harvester.webdav.WAFRemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.WebDavParams;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class WAFRetriever
implements RemoteRetriever {
    public static final String type_GetCapabilities = "GetCapabilities";
    public static final String type_xml = "xml";
    public static final String type_dir = "directory";
    private AtomicBoolean cancelMonitor;
    private Logger log;
    private WebDavParams params;
    private List<RemoteFile> files = new ArrayList<RemoteFile>();

    WAFRetriever() {
    }

    public static String getFileType(String path) {
        if (path.toUpperCase().contains("REQUEST=GETCAPABILITIES")) {
            return type_GetCapabilities;
        }
        if (path.toUpperCase().endsWith(".XML")) {
            return type_xml;
        }
        if (path.toUpperCase().endsWith("/")) {
            return type_dir;
        }
        return null;
    }

    @Override
    public void init(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, WebDavParams params) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.params = params;
    }

    @Override
    public List<RemoteFile> retrieve() throws Exception {
        this.files.clear();
        this.retrieveFiles(this.params.url);
        return this.files;
    }

    @Override
    public void destroy() {
    }

    private void retrieveFiles(String wafurl) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Scanning resource : " + wafurl);
        }
        Document doc = Jsoup.parse((URL)new URL(wafurl), (int)3000);
        Elements links = doc.select("a[href]");
        for (Element link : links) {
            if (this.cancelMonitor.get()) {
                this.files.clear();
                return;
            }
            String url = link.attr("abs:href");
            String fileType = WAFRetriever.getFileType(url);
            if (fileType == null) continue;
            if (fileType.equals(type_dir)) {
                if (!this.params.recurse || !url.contains(wafurl) || url.equals(wafurl)) continue;
                this.retrieveFiles(url);
                continue;
            }
            this.files.add(new WAFRemoteFile(url));
        }
    }
}

