/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.simpleUrl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.fao.geonet.Logger;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.simpleUrl.Aligner;
import org.fao.geonet.kernel.harvest.harvester.simpleUrl.SimpleUrlParams;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpResponse;

class Harvester
implements IHarvester<HarvestResult> {
    public static final String LOGGER_NAME = "geonetwork.harvester.json";
    private final AtomicBoolean cancelMonitor;
    private Logger log;
    private SimpleUrlParams params;
    private ServiceContext context;
    @Autowired
    GeonetHttpRequestFactory requestFactory;
    private List<HarvestError> errors = new LinkedList<HarvestError>();

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, SimpleUrlParams params) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        log.debug("Retrieving simple URL: " + this.params.getName());
        this.requestFactory = (GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class);
        String jsonResponse = this.retrieveUrl(this.params.url, log);
        if (this.cancelMonitor.get()) {
            return new HarvestResult();
        }
        log.debug("Response is: " + jsonResponse);
        int numberOfRecordsToHarvest = -1;
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonObj = objectMapper.readTree(jsonResponse);
        if (StringUtils.isNotEmpty((String)this.params.numberOfRecordPath)) {
            try {
                numberOfRecordsToHarvest = jsonObj.at(this.params.numberOfRecordPath).asInt();
                log.debug("Number of records to harvest: " + numberOfRecordsToHarvest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean error = false;
        HarvestResult result = null;
        HashMap<String, Element> allUuids = new HashMap<String, Element>();
        try {
            Aligner aligner = new Aligner(this.cancelMonitor, this.context, this.params, log);
            List<String> listOfUrlForPages = this.buildListOfUrl(this.params, numberOfRecordsToHarvest);
            for (int i = 0; i < listOfUrlForPages.size(); ++i) {
                if (i != 0) {
                    jsonResponse = this.retrieveUrl(listOfUrlForPages.get(i), log);
                    jsonObj = objectMapper.readTree(jsonResponse);
                }
                HashMap<String, Element> uuids = new HashMap<String, Element>();
                if (!StringUtils.isNotEmpty((String)this.params.loopElement)) continue;
                try {
                    JsonNode nodes = jsonObj.at(this.params.loopElement);
                    log.debug("Number of records in response: " + nodes.size());
                    nodes.forEach(record -> {
                        String uuid = this.extractUuidFromIdentifier(record.get(this.params.recordIdPath).asText());
                        String apiUrl = this.params.url.split("\\?")[0];
                        URL url = null;
                        try {
                            url = new URL(apiUrl);
                            String nodeUrl = url.getProtocol() + "://" + url.getAuthority();
                            Element xml = this.convertRecordToXml((JsonNode)record, uuid, apiUrl, nodeUrl);
                            uuids.put(uuid, xml);
                        }
                        catch (MalformedURLException e) {
                            log.warning("Failed to parse Node URL");
                        }
                    });
                    aligner.align(uuids, this.errors);
                    allUuids.putAll(uuids);
                    continue;
                }
                catch (Exception e) {
                    log.warning("Failed to collect record in response");
                }
            }
            result = aligner.cleanupRemovedRecords(allUuids.keySet());
        }
        catch (Exception t) {
            error = true;
            log.error("Unknown error trying to harvest");
            log.error(t.getMessage());
            log.error((Throwable)t);
            this.errors.add(new HarvestError(this.context, t));
        }
        catch (Throwable t) {
            error = true;
            log.fatal("Something unknown and terrible happened while harvesting");
            log.fatal(t.getMessage());
            this.errors.add(new HarvestError(this.context, t));
        }
        log.info("Total records processed in all searches :" + allUuids.size());
        if (error) {
            log.warning("Due to previous errors the align process has not been called");
        }
        return result;
    }

    private String extractUuidFromIdentifier(String identifier) {
        String uuid = identifier;
        if (Lib.net.isUrlValid(uuid)) {
            uuid = uuid.replaceFirst(".*/([^/?]+).*", "$1");
        }
        return uuid;
    }

    @VisibleForTesting
    protected List<String> buildListOfUrl(SimpleUrlParams params, int numberOfRecordsToHarvest) {
        ArrayList<String> urlList = new ArrayList<String>();
        if (StringUtils.isEmpty((String)params.pageSizeParam)) {
            urlList.add(params.url);
            return urlList;
        }
        int numberOfRecordsPerPage = -1;
        String pageSizeParamValue = params.url.replaceAll(".*[?&]" + params.pageSizeParam + "=([0-9]+).*", "$1");
        if (!StringUtils.isNumeric((String)pageSizeParamValue)) {
            this.log.warning(String.format("Page size param '%s' not found or is not a numeric in URL '%s'. Can't build a list of pages.", params.pageSizeParam, params.url));
            urlList.add(params.url);
            return urlList;
        }
        numberOfRecordsPerPage = Integer.parseInt(pageSizeParamValue);
        String pageFromParamValue = params.url.replaceAll(".*[?&]" + params.pageFromParam + "=([0-9]+).*", "$1");
        boolean startAtZero = false;
        if (!StringUtils.isNumeric((String)pageFromParamValue)) {
            this.log.warning(String.format("Page from param '%s' not found or is not a numeric in URL '%s'. Can't build a list of pages.", params.pageFromParam, params.url));
            urlList.add(params.url);
            return urlList;
        }
        startAtZero = Integer.parseInt(pageFromParamValue) == 0;
        int numberOfPages = Math.abs((numberOfRecordsToHarvest + (startAtZero ? -1 : 0)) / numberOfRecordsPerPage) + 1;
        for (int i = 0; i < numberOfPages; ++i) {
            int from = i * numberOfRecordsPerPage + (startAtZero ? 0 : 1);
            int size = i == numberOfPages - 1 ? numberOfRecordsToHarvest - from + (startAtZero ? 0 : 1) : numberOfRecordsPerPage;
            String url = params.url.replaceAll(params.pageFromParam + "=[0-9]+", params.pageFromParam + "=" + from).replaceAll(params.pageSizeParam + "=[0-9]+", params.pageSizeParam + "=" + size);
            urlList.add(url);
        }
        return urlList;
    }

    private Element convertRecordToXml(JsonNode record, String uuid, String apiUrl, String nodeUrl) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String recordAsXml = XML.toString((Object)new JSONObject(objectMapper.writeValueAsString((Object)record)), (String)"record");
            recordAsXml = Xml.stripNonValidXMLCharacters((String)recordAsXml).replace("<@", "<").replace("</@", "</");
            Element recordAsElement = Xml.loadString((String)recordAsXml, (boolean)false);
            recordAsElement.addContent((Content)new Element("uuid").setText(uuid));
            recordAsElement.addContent((Content)new Element("apiUrl").setText(apiUrl));
            recordAsElement.addContent((Content)new Element("nodeUrl").setText(nodeUrl));
            Path importXsl = this.context.getAppPath().resolve("xsl/conversion/import");
            Path xslPath = importXsl.resolve(this.params.toISOConversion + ".xsl");
            return Xml.transform((Element)recordAsElement, (Path)xslPath);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveUrl(String url, Logger log) throws Exception {
        String string;
        ClientHttpResponse httpResponse;
        block4: {
            if (!Lib.net.isUrlValid(url)) {
                throw new BadParameterEx("Invalid URL", (Object)url);
            }
            HttpGet httpMethod = null;
            httpResponse = null;
            try {
                httpMethod = new HttpGet(this.createUrl(url));
                httpResponse = this.requestFactory.execute((HttpUriRequest)httpMethod);
                int status = httpResponse.getRawStatusCode();
                Log.debug((String)LOGGER_NAME, (Object)("Request status code: " + status));
                string = CharStreams.toString((Readable)new InputStreamReader(httpResponse.getBody()));
                if (httpMethod == null) break block4;
            }
            catch (Throwable throwable) {
                if (httpMethod != null) {
                    httpMethod.releaseConnection();
                }
                IOUtils.closeQuietly(httpResponse);
                throw throwable;
            }
            httpMethod.releaseConnection();
        }
        IOUtils.closeQuietly((Closeable)httpResponse);
        return string;
    }

    private URI createUrl(String jsonUrl) throws URISyntaxException {
        return new URI(jsonUrl);
    }

    @Override
    public List<HarvestError> getErrors() {
        return this.errors;
    }
}

