/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet;

import com.google.common.base.Splitter;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;

class Search {
    public int from;
    public int to;
    public String freeText;
    public String title;
    public String abstrac;
    public String keywords;
    public boolean digital;
    public boolean hardcopy;
    public String sourceUuid;
    public String sourceName;
    public String anyField;
    public String anyValue;

    public Search() {
    }

    public Search(Element search) throws BadParameterEx {
        this.freeText = Util.getParam((Element)search, (String)"freeText", (String)"");
        this.title = Util.getParam((Element)search, (String)"title", (String)"");
        this.abstrac = Util.getParam((Element)search, (String)"abstract", (String)"");
        this.keywords = Util.getParam((Element)search, (String)"keywords", (String)"");
        this.digital = Util.getParam((Element)search, (String)"digital", (boolean)false);
        this.hardcopy = Util.getParam((Element)search, (String)"hardcopy", (boolean)false);
        this.anyField = Util.getParam((Element)search, (String)"anyField", (String)"");
        this.anyValue = Util.getParam((Element)search, (String)"anyValue", (String)"");
        Element source = search.getChild("source");
        this.sourceUuid = Util.getParam((Element)source, (String)"uuid", (String)"");
        this.sourceName = Util.getParam((Element)source, (String)"name", (String)"");
    }

    public static Search createEmptySearch(int from, int to) throws BadParameterEx {
        Search s = new Search(new Element("search"));
        s.setRange(from, to);
        return s;
    }

    public Search copy() {
        Search s = new Search();
        s.freeText = this.freeText;
        s.title = this.title;
        s.abstrac = this.abstrac;
        s.keywords = this.keywords;
        s.digital = this.digital;
        s.hardcopy = this.hardcopy;
        s.sourceUuid = this.sourceUuid;
        s.sourceName = this.sourceName;
        s.anyField = this.anyField;
        s.anyValue = this.anyValue;
        s.from = this.from;
        s.to = this.to;
        return s;
    }

    public Element createRequest() {
        Element req = new Element("request");
        this.add(req, "from", Integer.toString(this.from));
        this.add(req, "to", Integer.toString(this.to));
        this.add(req, "any", this.freeText);
        this.add(req, "title", this.title);
        this.add(req, "abstract", this.abstrac);
        this.add(req, "themekey", this.keywords);
        this.add(req, "siteId", this.sourceUuid);
        try {
            Iterable fields = Splitter.on((char)';').split((CharSequence)this.anyField);
            Iterable values = Splitter.on((char)';').split((CharSequence)this.anyValue);
            Iterator valuesIterator = values.iterator();
            for (String field : fields) {
                String value = (String)valuesIterator.next();
                if (field == null || value == null) continue;
                this.add(req, field, value);
            }
        }
        catch (Exception e) {
            throw new OperationAbortedEx("Search request criteria error. Check that the free criteria fields '" + this.anyField + "' and values '" + this.anyValue + "' are correct. You MUST have the same number of criteria and values.", (Object)e);
        }
        if (this.digital) {
            Lib.element.add(req, "digital", (Object)"on");
        }
        if (this.hardcopy) {
            Lib.element.add(req, "paper", (Object)"on");
        }
        if (Log.isDebugEnabled((String)"geonetwork.harvest-man")) {
            Log.debug((String)"geonetwork.harvest-man", (Object)("Search request is " + Xml.getString((Element)req)));
        }
        return req;
    }

    private void add(Element req, String name, String value) {
        if (value.length() != 0) {
            req.addContent((Content)new Element(name).setText(value));
        }
    }

    public void setRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("from", this.from).append("to", this.to).append("freeText", (Object)this.freeText).append("title", (Object)this.title).append("abstrac", (Object)this.abstrac).append("keywords", (Object)this.keywords).append("digital", this.digital).append("hardcopy", this.hardcopy).append("sourceUuid", (Object)this.sourceUuid).append("sourceName", (Object)this.sourceName).append("anyField", (Object)this.anyField).append("anyValue", (Object)this.anyValue).toString();
    }
}

