/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.geonet.Group;
import org.fao.geonet.kernel.harvest.harvester.geonet.Search;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public class GeonetParams
extends AbstractParams {
    public String host;
    public boolean createRemoteCategory;
    public boolean mefFormatFull;
    public String xslfilter;
    private String node;
    private Boolean useChangeDateForUpdate;
    private ArrayList<Search> alSearches = new ArrayList();
    private ArrayList<Group> alCopyPolicy = new ArrayList();

    public GeonetParams(DataManager dm) {
        super(dm);
    }

    @Override
    public void create(Element node) throws BadInputEx {
        super.create(node);
        Element site = node.getChild("site");
        Element policy = node.getChild("groupsCopyPolicy");
        Element searches = node.getChild("searches");
        this.host = Util.getParam((Element)site, (String)"host", (String)"");
        this.setNode(Util.getParam((Element)site, (String)"node", (String)"srv"));
        this.setUseChangeDateForUpdate(Util.getParam((Element)site, (String)"useChangeDateForUpdate", (boolean)false));
        this.createRemoteCategory = Util.getParam((Element)site, (String)"createRemoteCategory", (boolean)false);
        this.mefFormatFull = Util.getParam((Element)site, (String)"mefFormatFull", (boolean)false);
        this.xslfilter = Util.getParam((Element)site, (String)"xslfilter", (String)"");
        this.addSearches(searches);
        this.addCopyPolicy(policy);
    }

    @Override
    public void update(Element node) throws BadInputEx {
        super.update(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        Element policy = node.getChild("groupsCopyPolicy");
        this.host = Util.getParam((Element)site, (String)"host", (String)this.host);
        this.setNode(Util.getParam((Element)site, (String)"node", (String)this.getNode()));
        this.setUseChangeDateForUpdate(Util.getParam((Element)site, (String)"useChangeDateForUpdate", (boolean)false));
        this.createRemoteCategory = Util.getParam((Element)site, (String)"createRemoteCategory", (boolean)this.createRemoteCategory);
        this.mefFormatFull = Util.getParam((Element)site, (String)"mefFormatFull", (boolean)this.mefFormatFull);
        this.xslfilter = Util.getParam((Element)site, (String)"xslfilter", (String)"");
        if (searches != null) {
            this.addSearches(searches);
        }
        if (policy != null) {
            this.addCopyPolicy(policy);
        }
    }

    public Iterable<Search> getSearches() {
        return this.alSearches;
    }

    public Iterable<Group> getGroupCopyPolicy() {
        return this.alCopyPolicy;
    }

    public String getServletPath() {
        if (StringUtils.isNotEmpty((String)this.host)) {
            try {
                return new URL(this.host).getPath();
            }
            catch (MalformedURLException ex) {
                Log.error((String)"geonetwork.harvest-man", (Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return "";
    }

    public boolean isSearchEmpty() {
        return this.alSearches.isEmpty();
    }

    @Override
    public GeonetParams copy() {
        GeonetParams copy = new GeonetParams(this.dm);
        this.copyTo(copy);
        copy.host = this.host;
        copy.node = this.node;
        copy.useChangeDateForUpdate = this.useChangeDateForUpdate;
        copy.createRemoteCategory = this.createRemoteCategory;
        copy.mefFormatFull = this.mefFormatFull;
        copy.xslfilter = this.xslfilter;
        for (Search s : this.alSearches) {
            copy.alSearches.add(s.copy());
        }
        for (Group g : this.alCopyPolicy) {
            copy.alCopyPolicy.add(g.copy());
        }
        return copy;
    }

    private void addSearches(Element searches) throws BadInputEx {
        this.alSearches.clear();
        if (searches == null) {
            return;
        }
        for (Object o : searches.getChildren("search")) {
            Element search = (Element)o;
            this.alSearches.add(new Search(search));
        }
    }

    private void addCopyPolicy(Element policy) throws BadInputEx {
        this.alCopyPolicy.clear();
        if (policy == null) {
            return;
        }
        for (Object o : policy.getChildren("group")) {
            Element group = (Element)o;
            this.alCopyPolicy.add(new Group(group));
        }
    }

    public String getNode() {
        if (this.node == null) {
            this.setNode("srv");
        }
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean useChangeDateForUpdate() {
        if (this.useChangeDateForUpdate == null) {
            this.setUseChangeDateForUpdate(false);
        }
        return this.useChangeDateForUpdate;
    }

    public void setUseChangeDateForUpdate(Boolean useChangeDateForUpdate) {
        if (useChangeDateForUpdate == null) {
            useChangeDateForUpdate = false;
        }
        this.useChangeDateForUpdate = useChangeDateForUpdate;
    }

    @Override
    public String getIcon() {
        return null;
    }
}

