/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public class AtomDescribe
implements Service {
    private static final String DATASET_IDENTIFIER_CODE_PARAM = "spatial_dataset_identifier_code";
    private static final String DATASET_IDENTIFIER_NS_PARAM = "spatial_dataset_identifier_namespace";
    private static final String SERVICE_IDENTIFIER = "fileIdentifier";

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new Exception("Inspire is disabled");
        }
        String fileIdentifier = Util.getParam((Element)params, (String)SERVICE_IDENTIFIER, (String)"");
        if (StringUtils.isEmpty((String)fileIdentifier)) {
            return this.processDatasetFeed(params, context);
        }
        return this.processServiceFeed(params, context);
    }

    private Element processDatasetFeed(Element params, ServiceContext context) throws Exception {
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        InspireAtomService service = (InspireAtomService)context.getBean(InspireAtomService.class);
        String datasetIdCode = Util.getParam((Element)params, (String)DATASET_IDENTIFIER_CODE_PARAM);
        String datasetIdNs = Util.getParam((Element)params, (String)DATASET_IDENTIFIER_NS_PARAM);
        Log.debug((String)"geonetwork.atom", (Object)("Processing dataset feed  (spatial_dataset_identifier_code: " + datasetIdCode + ", " + DATASET_IDENTIFIER_NS_PARAM + ": " + datasetIdNs + " )"));
        String datasetUuid = service.retrieveDatasetUuidFromIdentifierNs(datasetIdCode, datasetIdNs);
        if (StringUtils.isEmpty((String)datasetUuid)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        String id = dm.getMetadataId(datasetUuid);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(datasetUuid);
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        return service.retrieveFeed(context, Integer.parseInt(id));
    }

    private Element processServiceFeed(Element params, ServiceContext context) throws Exception {
        String fileIdentifier = Util.getParam((Element)params, (String)SERVICE_IDENTIFIER);
        Log.debug((String)"geonetwork.atom", (Object)("Processing service feed  (fileIdentifier: " + fileIdentifier + " )"));
        InspireAtomService service = (InspireAtomService)context.getBean(InspireAtomService.class);
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        String id = dm.getMetadataId(fileIdentifier);
        if (StringUtils.isEmpty((String)id)) {
            throw new MetadataNotFoundEx(fileIdentifier);
        }
        Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
        Element md = dm.getMetadata(id);
        String schema = dm.getMetadataSchema(id);
        if (!InspireAtomUtil.isServiceMetadata(dm, schema, md)) {
            throw new Exception("No service metadata found with uuid:" + fileIdentifier);
        }
        return service.retrieveFeed(context, Integer.parseInt(id));
    }
}

