/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quartz2;

import org.apache.camel.CamelContext;
import org.apache.camel.component.quartz2.QuartzEndpoint;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuartzHelper {
    public static final Logger LOG = LoggerFactory.getLogger(QuartzEndpoint.class);

    private QuartzHelper() {
    }

    public static String getQuartzContextName(CamelContext camelContext) {
        if (camelContext.getManagementName() != null) {
            return camelContext.getManagementName();
        }
        return camelContext.getManagementNameStrategy().getName();
    }

    public static void updateJobDataMap(CamelContext camelContext, JobDetail jobDetail, String endpointUri) {
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        String camelContextName = QuartzHelper.getQuartzContextName(camelContext);
        LOG.debug("Adding camelContextName={}, endpointUri={} into job data map.", (Object)camelContextName, (Object)endpointUri);
        jobDataMap.put("CamelQuartzCamelContextName", camelContextName);
        jobDataMap.put("CamelQuartzEndpoint", endpointUri);
    }
}

