/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.standards;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.standards.StandardsUtils;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.editorconfig.BatchEditing;
import org.fao.geonet.kernel.schema.editorconfig.Editor;
import org.fao.geonet.kernel.schema.labels.Codelists;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/standards"})
@Tag(name="standards", description="Standard related operations")
@Controller(value="standards")
public class StandardsApi
implements ApplicationContextAware {
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    LanguageUtils languageUtils;
    private ApplicationContext context;

    public synchronized void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Operation(summary="Get standards")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of standards.")})
    public List<MetadataSchema> getStandardConfigurations() throws Exception {
        Set schemaIds = this.schemaManager.getSchemas();
        ArrayList<MetadataSchema> schemaList = new ArrayList<MetadataSchema>(schemaIds.size());
        schemaIds.stream().forEach(id -> schemaList.add(this.schemaManager.getSchema(id)));
        return schemaList;
    }

    @Operation(summary="Reload standards")
    @RequestMapping(value={"/reload"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Standards reloaded.")})
    public void reloadSchema() throws Exception {
        Set schemaIds = this.schemaManager.getSchemas();
        schemaIds.stream().forEach(id -> this.schemaManager.reloadSchema(id));
    }

    @Operation(summary="Get batch editor configuration for standards")
    @RequestMapping(value={"/batchconfiguration"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Batch editor configuration.")})
    @ResponseBody
    public Map<String, BatchEditing> getConfigurations(@Parameter(description="Schema identifiers", required=false, example="iso19139") @RequestParam(required=false) String[] schema) throws Exception {
        List<Object> listOfRequestedSchema = schema == null ? new ArrayList() : Arrays.asList(schema);
        Set listOfSchemas = this.schemaManager.getSchemas();
        HashMap<String, BatchEditing> schemasConfig = new HashMap<String, BatchEditing>();
        for (String schemaIdentifier : listOfSchemas) {
            MetadataSchema metadataSchema;
            Editor editorConfiguration;
            if (listOfRequestedSchema.size() != 0 && !listOfRequestedSchema.contains(schemaIdentifier) || (editorConfiguration = (metadataSchema = this.schemaManager.getSchema(schemaIdentifier)).getConfigEditor()) == null) continue;
            schemasConfig.put(schemaIdentifier, editorConfiguration.getBatchEditing());
        }
        return schemasConfig;
    }

    @Operation(summary="Get batch editor configuration for a standard")
    @RequestMapping(value={"/{schema}/batchconfiguration"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, BatchEditing> getConfiguration(@Parameter(description="Schema identifier", required=true, example="iso19139") @PathVariable String schema) throws Exception {
        HashMap<String, BatchEditing> schemasConfig = new HashMap<String, BatchEditing>();
        MetadataSchema metadataSchema = this.schemaManager.getSchema(schema);
        Editor editorConfiguration = metadataSchema.getConfigEditor();
        if (editorConfiguration != null) {
            schemasConfig.put(schema, editorConfiguration.getBatchEditing());
        }
        return schemasConfig;
    }

    @Operation(summary="Get multiple codelist translations", description="All translations are combined in the same object. No distinction by codelist. This is useful if you need lots of codelists terms to be loaded.")
    @RequestMapping(value={"/{schema}/codelists"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getCodelistsTranslations(@Parameter(description="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @Parameter(description="Codelist element name or alias") @RequestParam String[] codelist, HttpServletRequest request) throws Exception {
        LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
        context.setLanguage(language.getISO3Language());
        for (String c : codelist) {
            Element e = StandardsUtils.getCodelist((String)c, (SchemaManager)this.schemaManager, (String)schema, null, null, null, (ServiceContext)context, null);
            List listOfEntry = e.getChildren("entry");
            for (Element entry : listOfEntry) {
                response.put(entry.getChildText("code"), entry.getChildText("label"));
            }
        }
        return response;
    }

    @Operation(summary="Get codelist translations")
    @RequestMapping(value={"/{schema}/codelists/{codelist}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getSchemaTranslations(@Parameter(description="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @Parameter(description="Codelist element name or alias") @PathVariable String codelist, @RequestParam(required=false) String parent, @RequestParam(required=false) String displayIf, @RequestParam(required=false) String xpath, @RequestParam(required=false) String isoType, HttpServletRequest request) throws Exception {
        LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
        context.setLanguage(language.getISO3Language());
        Element e = StandardsUtils.getCodelist((String)codelist, (SchemaManager)this.schemaManager, (String)schema, (String)parent, (String)xpath, (String)isoType, (ServiceContext)context, (String)displayIf);
        List listOfEntry = e.getChildren("entry");
        for (Element entry : listOfEntry) {
            response.put(entry.getChildText("code"), entry.getChildText("label"));
        }
        return response;
    }

    @Operation(summary="Get codelist details")
    @RequestMapping(value={"/{schema}/codelists/{codelist}/details"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public Codelists.Codelist getSchemaCodelistsWithDetails(@Parameter(description="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @Parameter(description="Codelist element name or alias") @PathVariable String codelist, @Parameter(description="Parent name with namespace which may indicate a more precise label as defined in context attribute.") @RequestParam(required=false) String parent, @Parameter(description="Display if condition as defined in the codelist.xml file. Allows to select a more precise codelist when more than one is defined for same name.") @RequestParam(required=false) String displayIf, @Parameter(description="XPath of the element to target which may indicate a more precise label as defined in context attribute.") @RequestParam(required=false) String xpath, @Parameter(description="ISO type of the element to target which may indicate a more precise label as defined in context attribute. (Same as context. TODO: Deprecate ?)") @RequestParam(required=false) String isoType, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
        context.setLanguage(language.getISO3Language());
        Element e = StandardsUtils.getCodelist((String)codelist, (SchemaManager)this.schemaManager, (String)schema, (String)parent, (String)xpath, (String)isoType, (ServiceContext)context, (String)displayIf);
        return (Codelists.Codelist)Xml.unmarshall((Element)e, Codelists.Codelist.class);
    }

    @Operation(summary="Get descriptor details")
    @RequestMapping(value={"/{schema}/descriptors/{element}/details"}, method={RequestMethod.GET}, produces={"application/json", "application/xml"})
    @ResponseBody
    public org.fao.geonet.kernel.schema.labels.Element getElementDetails(@Parameter(description="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @Parameter(description="Descriptor name", required=true) @PathVariable String element, @RequestParam(required=false) String parent, @RequestParam(required=false) String displayIf, @RequestParam(required=false) String xpath, @RequestParam(required=false) String isoType, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        Locale language = this.languageUtils.parseAcceptLanguage(request.getLocales());
        context.setLanguage(language.getISO3Language());
        Element e = StandardsUtils.getLabel((String)element, (SchemaManager)this.schemaManager, (String)schema, (String)parent, (String)xpath, (String)isoType, (String)displayIf, (ServiceContext)context);
        return (org.fao.geonet.kernel.schema.labels.Element)Xml.unmarshall((Element)e, org.fao.geonet.kernel.schema.labels.Element.class);
    }

    @Operation(summary="Get editor associated resources panel configuration")
    @RequestMapping(value={"/{schema}/editor/associatedpanel/config/{name:[a-zA-Z]+}.json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getEditorAssociatedPanelConfiguration(@Parameter(description="Schema identifier", required=true, example="iso19139") @PathVariable String schema, @Parameter(description="Configuration identifier", required=true, example="default") @PathVariable String name) throws Exception {
        HashSet<String> schemasProcessed = new HashSet<String>();
        while (StringUtils.isNotEmpty((String)schema) && !schemasProcessed.contains(schema)) {
            schemasProcessed.add(schema);
            MetadataSchema metadataSchema = this.schemaManager.getSchema(schema);
            Path schemaDir = metadataSchema.getSchemaDir();
            Path configFile = schemaDir.resolve("config").resolve("associated-panel").resolve(name + ".json");
            if (Files.exists(configFile, new LinkOption[0])) {
                try {
                    String jsonConfig = new String(Files.readAllBytes(configFile));
                    new JSONObject(jsonConfig);
                    return jsonConfig;
                }
                catch (Exception e) {
                    throw new WebApplicationException(String.format("Associated panel configuration '%s' for schema '%s' is invalid. Error is: %s", name, metadataSchema.getName(), e.getMessage()));
                }
            }
            schema = metadataSchema.getDependsOn();
        }
        throw new ResourceNotFoundException(String.format("Associated panel '%s' configuration not found for schema and its dependency '%s'.", name, ((Object)schemasProcessed).toString()));
    }
}

