/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.reports;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.context.ServiceContext;
import org.apache.commons.csv.CSVPrinter;
import org.fao.geonet.api.reports.IReport;
import org.fao.geonet.api.reports.ReportFilter;
import org.fao.geonet.api.reports.ReportUtils;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataFileUpload;
import org.fao.geonet.domain.MetadataFileUpload_;
import org.fao.geonet.domain.User;
import org.fao.geonet.repository.MetadataFileUploadRepository;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.MetadataFileUploadSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;

public class ReportUploads
implements IReport {
    private final ReportFilter reportFilter;
    @Autowired
    MetadataRepository metadataRepository;

    public ReportUploads(ReportFilter filter) {
        this.reportFilter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ServiceContext context, PrintWriter writer) throws Exception {
        CSVPrinter csvFilePrinter = null;
        try {
            csvFilePrinter = new CSVPrinter((Appendable)writer, ReportUtils.CSV_FORMAT);
            MetadataFileUploadRepository uploadRepository = (MetadataFileUploadRepository)context.getBean(MetadataFileUploadRepository.class);
            Sort sort = Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{MetadataFileUpload_.uploadDate})});
            List records = uploadRepository.findAll(MetadataFileUploadSpecs.uploadDateBetweenAndByGroups((ISODate)this.reportFilter.getBeginDate(), (ISODate)this.reportFilter.getEndDate(), this.reportFilter.getGroups()), sort);
            csvFilePrinter.printRecord(new Object[]{"Metadata file uploads"});
            csvFilePrinter.println();
            String[] entries = "Metadata ID#Metadata Title#File download#File download date#Requester name#Requester mail#Requester organisation#Requester comments#Username#Surname#Name#Email#Profile#Delete date".split("#");
            csvFilePrinter.printRecord(Arrays.asList(entries));
            List users = ((UserRepository)context.getBean(UserRepository.class)).findAll();
            for (MetadataFileUpload fileUpload : records) {
                String username = fileUpload.getUserName();
                String name = "";
                String surname = "";
                String email = "";
                String profile = "";
                String requesterName = "";
                String requesterMail = "";
                Optional<User> userFilter = users.stream().filter(u -> u.getUsername().equals(username)).findFirst();
                if (userFilter.isPresent()) {
                    User user = userFilter.get();
                    name = Optional.ofNullable(user.getName()).orElse("");
                    surname = Optional.ofNullable(user.getSurname()).orElse("");
                    email = Optional.ofNullable(user.getEmail()).orElse("");
                    profile = user.getProfile().name();
                }
                String fileName = fileUpload.getFileName();
                Optional metadata = this.metadataRepository.findById((Object)fileUpload.getMetadataId());
                String metadataUuid = ((Metadata)metadata.get()).getUuid();
                String metadataTitle = ReportUtils.retrieveMetadataTitle(metadataUuid);
                String uploadDescription = "";
                HashSet<String> fields = new HashSet<String>();
                fields.add("linkage_name_des");
                ArrayList<String> record = new ArrayList<String>();
                record.add(metadataUuid);
                record.add(metadataTitle);
                record.add(fileName);
                record.add(uploadDescription);
                record.add(fileUpload.getUploadDate());
                record.add(username);
                record.add(surname);
                record.add(name);
                record.add(email);
                record.add(profile);
                record.add(fileUpload.getDeletedDate());
                csvFilePrinter.printRecord(record);
            }
        }
        finally {
            writer.flush();
            if (csvFilePrinter != null) {
                csvFilePrinter.flush();
            }
        }
    }
}

