/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.fao.geonet.api.registries.model.Crs;
import org.fao.geonet.api.registries.model.CrsType;
import org.fao.geonet.utils.Log;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CrsUtils {
    public static List<Crs> search(String[] filters, CrsType crsType, int rows) {
        ArrayList<Crs> crsList = new ArrayList<Crs>();
        int i = 0;
        Class crsTypeClass = crsType != null ? crsType.getClazz() : CoordinateReferenceSystem.class;
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            String authorityTitle = factory.getAuthority().getTitle() == null ? "" : factory.getAuthority().getTitle().toString();
            String authorityEdition = factory.getAuthority().getEdition() == null ? "" : factory.getAuthority().getEdition().toString();
            String authorityCodeSpace = "";
            Collection ids = factory.getAuthority().getIdentifiers();
            for (Identifier id : ids) {
                authorityCodeSpace = id.getCode();
            }
            try {
                Set codes = factory.getAuthorityCodes(crsTypeClass);
                for (Object codeObj : codes) {
                    String description;
                    String code = (String)codeObj;
                    try {
                        description = factory.getDescriptionText(code).toString();
                    }
                    catch (Exception e1) {
                        description = "-";
                    }
                    if (!CrsUtils.matchesFilter(description = description + " (" + authorityCodeSpace + ":" + code + ")", filters)) continue;
                    crsList.add(new Crs(code, authorityTitle, authorityEdition, authorityCodeSpace, description));
                    if (++i < rows) continue;
                    return crsList;
                }
            }
            catch (FactoryException e) {
                Log.error((String)"geonetwork", (Object)e.getMessage(), (Throwable)e);
            }
        }
        return crsList;
    }

    public static Crs getById(String crsId) {
        for (Object object : ReferencingFactoryFinder.getCRSAuthorityFactories(null)) {
            CRSAuthorityFactory factory = (CRSAuthorityFactory)object;
            try {
                Set codes = factory.getAuthorityCodes(CoordinateReferenceSystem.class);
                for (Object codeObj : codes) {
                    String description;
                    String code = (String)codeObj;
                    if (!code.equals(crsId)) continue;
                    String authorityTitle = factory.getAuthority().getTitle() == null ? "" : factory.getAuthority().getTitle().toString();
                    String authorityEdition = factory.getAuthority().getEdition() == null ? "" : factory.getAuthority().getEdition().toString();
                    String authorityCodeSpace = "";
                    Collection ids = factory.getAuthority().getIdentifiers();
                    for (Identifier id : ids) {
                        authorityCodeSpace = id.getCode();
                    }
                    try {
                        description = factory.getDescriptionText(code).toString();
                    }
                    catch (Exception e1) {
                        description = "-";
                    }
                    description = description + " (" + authorityCodeSpace + ":" + code + ")";
                    return new Crs(code, authorityTitle, authorityEdition, authorityCodeSpace, description);
                }
            }
            catch (FactoryException factoryException) {
            }
        }
        return null;
    }

    protected static boolean matchesFilter(String input, String[] filters) {
        String upperCasedInput = input.toUpperCase();
        for (String match : filters) {
            if (upperCasedInput.contains(match.toUpperCase())) continue;
            return false;
        }
        return true;
    }
}

