/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy.template;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.api.records.formatters.groovy.template.TNode;
import org.fao.geonet.api.records.formatters.groovy.template.TRenderContext;
import org.fao.geonet.api.records.formatters.groovy.template.TextContentParser;
import org.xml.sax.Attributes;

public class TNodeIf
extends TNode {
    public static final double PRECISION = 1.0E-9;
    private final String expr;
    private final boolean not;
    private final Set<String> scriptVariables;
    private final boolean onlyChildren;

    public TNodeIf(SystemInfo info, TextContentParser parser, String qName, Attributes attributes, String expr, boolean onlyChildren) throws IOException {
        super(info, parser, qName, attributes);
        this.onlyChildren = onlyChildren;
        Matcher matcher = TextContentParser.INTERPOLATION_PATTERN.matcher(expr);
        if (matcher.find()) {
            this.scriptVariables = Sets.newHashSet();
            int start = 0;
            StringBuilder builder = new StringBuilder();
            do {
                String key = matcher.group(1).trim();
                this.scriptVariables.add(key);
                builder.append(expr, start, matcher.start());
                builder.append(key);
                start = matcher.end();
            } while (matcher.find());
            builder.append(expr.substring(start));
            this.expr = builder.toString();
            this.not = false;
        } else {
            this.scriptVariables = null;
            if (expr.startsWith("!")) {
                this.not = true;
                this.expr = expr.substring(1);
            } else {
                this.not = false;
                this.expr = expr;
            }
        }
    }

    @VisibleForTesting
    static String isTruthy(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof String) {
            String sVal = (String)val;
            return sVal.isEmpty() ? "empty" : null;
        }
        if (val instanceof Iterable) {
            Iterable itVal = (Iterable)val;
            return itVal.iterator().hasNext() ? null : "empty";
        }
        if (val instanceof Enumeration) {
            Enumeration itVal = (Enumeration)val;
            return itVal.hasMoreElements() ? null : "empty";
        }
        if (val instanceof Iterator) {
            Iterator itVal = (Iterator)val;
            return itVal.hasNext() ? null : "empty";
        }
        if (val instanceof Map) {
            Map mapVal = (Map)val;
            return mapVal.isEmpty() ? "empty" : null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val != false ? null : "false";
        }
        if (val instanceof Double) {
            return Math.abs((Double)val) > 1.0E-9 ? null : "0";
        }
        if (val instanceof Float) {
            return (double)Math.abs(((Float)val).floatValue()) > 1.0E-9 ? null : "0";
        }
        if (val instanceof Number) {
            return ((Number)val).intValue() != 0 ? null : "0";
        }
        if (val instanceof Character) {
            return null;
        }
        if (val.getClass().isArray()) {
            return ((Object[])val).length > 0 ? null : "empty";
        }
        throw new AssertionError((Object)("Not a recognized type: " + val.getClass() + ": " + val));
    }

    @Override
    protected Optional<String> canRender(TRenderContext context) {
        if (this.scriptVariables == null) {
            Object val = context.getModelValue(this.expr);
            String truthy = TNodeIf.isTruthy(val);
            if (this.not) {
                return truthy != null ? Optional.absent() : Optional.of((Object)("fmt-if=!" + this.expr + " is false (" + this.expr + " is true)"));
            }
            if (truthy != null) {
                return Optional.of((Object)("fmt-if=" + this.expr + " is " + truthy));
            }
            return Optional.absent();
        }
        Binding binding = new Binding();
        for (String scriptVariable : this.scriptVariables) {
            binding.setVariable(scriptVariable, context.getModelValue(scriptVariable));
        }
        GroovyShell shell = new GroovyShell(binding);
        Object value = shell.evaluate(this.expr);
        if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
            return Optional.absent();
        }
        return Optional.of((Object)(this.expr + " resulted in a non-true value: '" + value + "'"));
    }

    @Override
    public void render(TRenderContext context) throws IOException {
        Optional<String> canRenderOptional = this.canRender(context);
        if (!canRenderOptional.isPresent()) {
            if (this.onlyChildren) {
                for (TNode child : this.getChildren()) {
                    child.render(context);
                }
            } else {
                super.render(context);
            }
        } else {
            this.addCannontRenderComment(context, canRenderOptional);
        }
    }
}

