/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters.groovy;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fao.geonet.api.records.formatters.groovy.Handler;
import org.fao.geonet.api.records.formatters.groovy.Handlers;
import org.fao.geonet.api.records.formatters.groovy.Logging;
import org.fao.geonet.api.records.formatters.groovy.SkipElement;
import org.fao.geonet.api.records.formatters.groovy.Sorter;
import org.fao.geonet.api.records.formatters.groovy.TransformationContext;

class TransformEngine {
    private final Handlers handlers;

    TransformEngine(Handlers handlers) {
        this.handlers = handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String processElementsInMode(String mode, Iterable selection, GPathResult sortByElement) throws IOException {
        StringBuilder resultantXml = new StringBuilder();
        TransformationContext context = TransformationContext.getContext();
        String oldMode = context.getCurrentMode();
        try {
            context.setCurrentMode(mode);
            List<GPathResult> flattenedSelection = this.flattenGPathResults(selection);
            this.processChildren(context, sortByElement, flattenedSelection, resultantXml);
            String string = resultantXml.toString();
            return string;
        }
        finally {
            context.setCurrentMode(oldMode);
        }
    }

    private List<GPathResult> flattenGPathResults(Iterable selection) {
        ArrayList result = Lists.newArrayList();
        for (Object path : selection) {
            GPathResult gpath = (GPathResult)path;
            if (gpath.isEmpty()) continue;
            for (Object el : gpath) {
                result.add((GPathResult)el);
            }
        }
        return result;
    }

    Collection<GPathResult> processElement(TransformationContext context, GPathResult elem, List<GPathResult> siblings, StringBuilder resultantXml) throws IOException {
        ArrayList handledSiblings = Lists.newArrayList((Iterable)elem);
        Logging.debug("Starting to process element: %s", elem, new Object[0]);
        boolean processChildren = true;
        for (SkipElement skipElement : this.handlers.getSkipElements()) {
            if (!skipElement.select(context, elem)) continue;
            this.processChildren(context, elem, this.processSkipElements(elem, skipElement), resultantXml);
            processChildren = false;
        }
        if (processChildren) {
            for (Handler handler : this.handlers.getHandlers().get((Object)context.getCurrentMode())) {
                if (!handler.select(context, elem)) continue;
                if (handler.isGroup()) {
                    for (GPathResult sibling : siblings) {
                        if (!handler.select(context, sibling)) continue;
                        handledSiblings.add(sibling);
                    }
                }
                handler.handle(context, handledSiblings, resultantXml);
                processChildren = false;
                break;
            }
        }
        if (processChildren) {
            Logging.debug("No Handler found for element: %s", elem, new Object[0]);
            this.processChildren(context, elem, this.processSkipElements(elem, null), resultantXml);
        }
        return handledSiblings;
    }

    private void processChildren(TransformationContext context, GPathResult md, List<GPathResult> sortedChildren, StringBuilder resultantXml) throws IOException {
        Sorter sorter;
        if (sortedChildren.isEmpty()) {
            return;
        }
        if (md != null && (sorter = this.handlers.findSorter(context, md)) != null) {
            Collections.sort(sortedChildren, sorter);
        }
        Set visitedByGroup = Sets.newIdentityHashSet();
        int size = sortedChildren.size();
        for (int i = 0; i < size; ++i) {
            GPathResult child = sortedChildren.get(i);
            if (visitedByGroup.contains(child)) continue;
            visitedByGroup.addAll(this.processElement(context, child, sortedChildren.subList(i + 1, size), resultantXml));
        }
    }

    private List<GPathResult> processSkipElements(GPathResult md, SkipElement skipElement) {
        GPathResult childrenPath = skipElement == null ? md.children() : skipElement.selectChildren(md);
        if (Logging.isDebugMode()) {
            Logging.debug("Starting to process %2$d children of: %1$s.", md, childrenPath.size());
        }
        return childrenPath.list();
    }
}

