/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceException;
import groovy.util.ScriptException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.api.records.formatters.FormatterImpl;
import org.fao.geonet.api.records.formatters.FormatterParams;
import org.fao.geonet.api.records.formatters.groovy.EnvironmentProxy;
import org.fao.geonet.api.records.formatters.groovy.Functions;
import org.fao.geonet.api.records.formatters.groovy.Handlers;
import org.fao.geonet.api.records.formatters.groovy.Transformer;
import org.fao.geonet.api.records.formatters.groovy.template.TemplateCache;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.utils.IO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroovyFormatter
implements FormatterImpl {
    private final Cache<Path, Transformer> transformers = CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(40L).initialCapacity(40).build();
    @Autowired
    private TemplateCache templateCache;
    private GroovyClassLoader baseClassLoader;
    private final Map<String, GroovyClassLoader> schemaClassLoaders = Maps.newHashMap();

    @VisibleForTesting
    Transformer findTransformer(final FormatterParams fparams) throws ExecutionException {
        return (Transformer)this.transformers.get((Object)fparams.formatDir, (Callable)new Callable<Transformer>(){

            @Override
            public Transformer call() throws Exception {
                return GroovyFormatter.this.createTransformer(fparams);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(FormatterParams fparams) throws Exception {
        EnvironmentProxy.clearContext();
        Transformer transformer = this.createTransformer(fparams);
        EnvironmentProxy.setCurrentEnvironment(fparams);
        try {
            List namespaces = ((SchemaManager)fparams.context.getBean(SchemaManager.class)).getSchema(fparams.schema).getNamespaces();
            String string = transformer.apply(fparams.metadata, namespaces);
            return string;
        }
        finally {
            EnvironmentProxy.clearContext();
        }
    }

    private synchronized Transformer createTransformer(FormatterParams fparams) throws Exception {
        Transformer transformer = (Transformer)this.transformers.getIfPresent((Object)fparams.formatDir);
        if (fparams.isDevMode() || transformer == null) {
            Path baseShared = ((GeonetworkDataDirectory)fparams.context.getBean(GeonetworkDataDirectory.class)).getFormatterDir().resolve("groovy");
            Path schemaFormatterDir = this.getSchemaPluginFormatterDir(fparams, fparams.schema);
            Path schemaShared = schemaFormatterDir.resolve("groovy");
            GroovyClassLoader cl = this.getParentClassLoader(fparams, fparams.schema, baseShared, schemaShared);
            URL[] roots = new URL[]{IO.toURL((Path)fparams.formatDir)};
            GroovyScriptEngine groovyScriptEngine = new GroovyScriptEngine(roots, (ClassLoader)cl);
            this.loadScripts(fparams.formatDir, groovyScriptEngine);
            Handlers handlers = new Handlers(fparams, schemaShared.getParent(), baseShared.getParent(), this.templateCache);
            EnvironmentProxy env = new EnvironmentProxy();
            Functions functions = new Functions(fparams, env);
            Binding binding = new Binding();
            binding.setVariable("handlers", (Object)handlers);
            binding.setVariable("env", (Object)env);
            binding.setVariable("f", (Object)functions);
            String scriptName = fparams.viewFile.toAbsolutePath().toUri().toString();
            groovyScriptEngine.run(scriptName, binding);
            transformer = new Transformer(handlers, functions, env, fparams.formatDir.toAbsolutePath());
            this.transformers.put((Object)fparams.formatDir, (Object)transformer);
        }
        return transformer;
    }

    private Path getSchemaPluginFormatterDir(FormatterParams fparams, String schema) {
        return ((SchemaManager)fparams.context.getBean(SchemaManager.class)).getSchemaDir(schema).resolve("formatter");
    }

    private GroovyClassLoader getParentClassLoader(FormatterParams fparams, String schema, Path baseShared, Path schemaShared) throws IOException, ResourceException, ScriptException {
        GroovyClassLoader cl = this.schemaClassLoaders.get(schema);
        if (fparams.isDevMode() || cl == null) {
            GroovyScriptEngine groovyScriptEngine;
            URL[] roots;
            GroovyClassLoader parent;
            ConfigFile newConfig = new ConfigFile(this.getSchemaPluginFormatterDir(fparams, schema), false, null);
            String dependOnSchema = newConfig.dependOn();
            if (dependOnSchema != null) {
                Path dependent = this.getSchemaPluginFormatterDir(fparams, dependOnSchema).resolve("groovy");
                parent = this.getParentClassLoader(fparams, dependOnSchema, baseShared, dependent);
            } else {
                if (fparams.isDevMode() || this.baseClassLoader == null) {
                    roots = new URL[]{IO.toURL((Path)baseShared)};
                    groovyScriptEngine = new GroovyScriptEngine(roots);
                    this.loadScripts(baseShared, groovyScriptEngine);
                    this.baseClassLoader = groovyScriptEngine.getGroovyClassLoader();
                }
                parent = this.baseClassLoader;
            }
            roots = new URL[]{IO.toURL((Path)schemaShared)};
            groovyScriptEngine = new GroovyScriptEngine(roots, (ClassLoader)parent);
            this.loadScripts(schemaShared, groovyScriptEngine);
            cl = groovyScriptEngine.getGroovyClassLoader();
            this.schemaClassLoaders.put(schema, cl);
        }
        return cl;
    }

    private void loadScripts(Path baseShared, final GroovyScriptEngine gse) throws ResourceException, ScriptException, IOException {
        if (!Files.exists(baseShared, new LinkOption[0])) {
            return;
        }
        final HashMap compileErrors = Maps.newHashMap();
        Files.walkFileTree(baseShared, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(dir, "*.groovy");){
                    for (Path path : paths) {
                        if (Files.isDirectory(path, new LinkOption[0])) continue;
                        try {
                            gse.loadScriptByName(path.toUri().toString());
                        }
                        catch (CompilationFailedException e) {
                            compileErrors.put(path, null);
                        }
                        catch (ResourceException | ScriptException e) {
                            throw new RuntimeException(e);
                            return FileVisitResult.CONTINUE;
                        }
                    }
                }
            }
        });
        int numErrors = 0;
        while (numErrors != compileErrors.size() && compileErrors.size() > 0) {
            numErrors = compileErrors.size();
            Iterator iter = compileErrors.keySet().iterator();
            while (iter.hasNext()) {
                Path file = (Path)iter.next();
                try {
                    gse.loadScriptByName(file.toUri().toString());
                    iter.remove();
                }
                catch (CompilationFailedException e) {
                    compileErrors.put(file, e);
                }
            }
            if (compileErrors.isEmpty()) continue;
            StringBuilder errorMsg = new StringBuilder("Errors occurred while compiling files:");
            for (Map.Entry entry : compileErrors.entrySet()) {
                errorMsg.append("\n\n").append(entry.getKey()).append(":\n").append(((Throwable)entry.getValue()).getMessage());
            }
            throw new AssertionError((Object)errorMsg.toString());
        }
    }
}

