/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import jeeves.server.ServiceConfig;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.formatters.FormatterConstants;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.ResourceNotFoundEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.utils.FilePathChecker;

abstract class AbstractFormatService {
    protected static final DirectoryStream.Filter<Path> FORMATTER_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path file) throws IOException {
            return Files.isDirectory(file, new LinkOption[0]) && this.isViewFileExists(file);
        }

        private boolean isViewFileExists(Path file) {
            return Files.exists(file.resolve("view.groovy"), new LinkOption[0]) || Files.exists(file.resolve("view.xsl"), new LinkOption[0]);
        }
    };

    AbstractFormatService() {
    }

    protected static boolean containsFile(Path container, Path desiredFile) throws IOException {
        if (!Files.exists(desiredFile, new LinkOption[0]) || !Files.exists(container, new LinkOption[0])) {
            return false;
        }
        Path canonicalDesired = desiredFile.toRealPath(new LinkOption[0]);
        Path canonicalContainer = container.toRealPath(new LinkOption[0]);
        while (canonicalDesired.getParent() != null && !canonicalDesired.getParent().equals(canonicalContainer)) {
            canonicalDesired = canonicalDesired.getParent();
        }
        return canonicalContainer.equals(canonicalDesired.getParent());
    }

    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    protected AbstractMetadata loadMetadata(IMetadataUtils metadataUtils, int id) {
        AbstractMetadata md = metadataUtils.findOne(id);
        if (md == null) {
            throw new IllegalArgumentException("No metadata found. id = " + id);
        }
        return md;
    }

    protected void checkLegalId(String paramName, String xslid) throws BadParameterEx {
        if (!FormatterConstants.ID_XSL_REGEX.matcher(xslid).matches()) {
            throw new BadParameterEx(paramName, (Object)("Only the following are permitted in the id" + FormatterConstants.ID_XSL_REGEX));
        }
    }

    protected Path getAndVerifyFormatDir(GeonetworkDataDirectory dataDirectory, String paramName, String xslid, Path schemaDir) throws BadParameterEx, IOException {
        if (xslid == null) {
            throw new BadParameterEx(paramName, (Object)("missing " + paramName + " param"));
        }
        FilePathChecker.verify((String)xslid);
        this.checkLegalId(paramName, xslid);
        Path formatDir = null;
        if (schemaDir != null && Files.exists(schemaDir, new LinkOption[0]) && !Files.exists(formatDir = schemaDir.resolve("formatter").resolve(xslid), new LinkOption[0])) {
            formatDir = null;
        }
        Path userXslDir = dataDirectory.getFormatterDir();
        if (formatDir == null) {
            formatDir = userXslDir.resolve(xslid);
        }
        if (!Files.exists(formatDir, new LinkOption[0])) {
            throw new BadParameterEx(paramName, (Object)("Format bundle " + xslid + " does not exist"));
        }
        if (!Files.isDirectory(formatDir, new LinkOption[0])) {
            throw new BadParameterEx(paramName, (Object)("Format bundle " + xslid + " is not a directory"));
        }
        if (!Files.exists(formatDir.resolve("view.xsl"), new LinkOption[0]) && !Files.exists(formatDir.resolve("view.groovy"), new LinkOption[0])) {
            throw new BadParameterEx(paramName, (Object)("Format bundle " + xslid + " is not a valid format bundle because it does not have a '" + "view.xsl" + "' file or a '" + "view.groovy" + "' file."));
        }
        if (!(AbstractFormatService.containsFile(userXslDir, formatDir) || schemaDir != null && AbstractFormatService.containsFile(schemaDir.resolve("formatter"), formatDir))) {
            throw new BadParameterEx(paramName, (Object)("Format bundle " + xslid + " is not a format bundle id because it does not reference a file contained within the userXslDir"));
        }
        return formatDir;
    }

    protected String resolveId(String id, String uuid) throws Exception {
        String resolvedId;
        try {
            if (uuid != null) {
                return this.resolveUuid(uuid);
            }
            if (id == null) {
                throw new ResourceNotFoundEx("A uuid or an id MUST be provided.");
            }
            Integer.parseInt(id);
            resolvedId = id;
        }
        catch (NumberFormatException e) {
            throw new BadParameterEx("Invalid integer value for parameter id '" + id + "'.", (Object)id);
        }
        catch (BadParameterEx e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceNotFoundEx("No record found with id '" + id + "' or uuid '" + uuid + "'.");
        }
        return resolvedId;
    }

    protected String resolveUuid(String uuid) throws Exception {
        if (StringUtils.isEmpty((String)uuid)) {
            throw new BadParameterEx("UUID can't be null or empty.", (Object)uuid);
        }
        String resolvedId = ((DataManager)ApplicationContextHolder.get().getBean(DataManager.class)).getMetadataId(uuid);
        if (resolvedId == null) {
            throw new ResourceNotFoundEx("No record found with uuid '" + uuid + "'.");
        }
        return resolvedId;
    }
}

