/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.util.ArrayList;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableCaching
@OpenAPIDefinition
public class OpenApiConfig {
    @Bean(name={"cacheManager"})
    public CacheManager cacheManager() {
        return new ConcurrentMapCacheManager(new String[]{"translations"});
    }

    @Bean
    @Autowired
    public OpenAPI OpenApiConfig(SettingManager settingManager) {
        ArrayList<Server> servers = new ArrayList<Server>();
        String version = settingManager.getValue("system/platform/version");
        String hostUrl = settingManager.getBaseURL().replaceAll("/+$", "");
        ServerVariable catalogVariable = new ServerVariable().description("The GeoNetwork catalog to contact").addEnumItem(hostUrl).addEnumItem("../..");
        catalogVariable.setDefault(hostUrl);
        ServerVariable portalVariable = new ServerVariable().description("The thematic portal").addEnumItem("srv");
        portalVariable.setDefault("srv");
        servers.add(new Server().description("My GeoNetwork").url("{catalog}/{portal}/api").variables(new ServerVariables().addServerVariable("catalog", catalogVariable).addServerVariable("portal", portalVariable)));
        return new OpenAPI().info(new Info().title(String.format("GeoNetwork %s OpenAPI Documentation", version)).description("This is the description of the GeoNetwork OpenAPI. Use this API to manage your catalog.").contact(new Contact().email("geonetwork-users@lists.sourceforge.net").name("GeoNetwork user mailing list").url("https://sourceforge.net/p/geonetwork/mailman/geonetwork-users/")).version(version).license(new License().name("GPL 2.0").url("http://www.gnu.org/licenses/old-licenses/gpl-2.0.html"))).externalDocs(new ExternalDocumentation().description("Learn how to access the catalog using the GeoNetwork REST API.").url(String.format("%s/doc/api", hostUrl))).servers(servers);
    }
}

