/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.extensions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Named;
import org.jclouds.Context;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.openstack.neutron.v2.NeutronApi;
import org.jclouds.openstack.neutron.v2.domain.Rule;
import org.jclouds.openstack.neutron.v2.domain.RuleDirection;
import org.jclouds.openstack.neutron.v2.domain.RuleEthertype;
import org.jclouds.openstack.neutron.v2.domain.RuleProtocol;
import org.jclouds.openstack.neutron.v2.domain.SecurityGroup;
import org.jclouds.openstack.neutron.v2.features.SecurityGroupApi;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.NeutronSecurityGroupToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.compute.functions.NovaSecurityGroupToSecurityGroup;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndId;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.rest.ApiContext;

public class NeutronSecurityGroupExtension
implements SecurityGroupExtension {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final NovaApi api;
    private final Supplier<Set<String>> regionIds;
    private final GroupNamingConvention.Factory namingConvention;
    private final LoadingCache<RegionAndName, org.jclouds.compute.domain.SecurityGroup> groupCreator;
    private final Supplier<Map<String, Location>> locationIndex;
    private final NeutronSecurityGroupToSecurityGroup.Factory neutronSecurityGroupToSecurityGroup;
    private final NovaSecurityGroupToSecurityGroup.Factory novaSecurityGroupToSecurityGroup;
    @Inject(optional=true)
    @Named(value="openstack-neutron")
    private Supplier<Context> neutronContextSupplier;

    @Inject
    NeutronSecurityGroupExtension(NovaApi api, @Region Supplier<Set<String>> regionIds, GroupNamingConvention.Factory namingConvention, LoadingCache<RegionAndName, org.jclouds.compute.domain.SecurityGroup> groupCreator, Supplier<Map<String, Location>> locationIndex, NeutronSecurityGroupToSecurityGroup.Factory neutronSecurityGroupToSecurityGroup, NovaSecurityGroupToSecurityGroup.Factory novaSecurityGroupToSecurityGroup) {
        this.api = api;
        this.regionIds = (Supplier)Preconditions.checkNotNull(regionIds, (Object)"regionIds");
        this.namingConvention = (GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention");
        this.groupCreator = groupCreator;
        this.locationIndex = locationIndex;
        this.neutronSecurityGroupToSecurityGroup = neutronSecurityGroupToSecurityGroup;
        this.novaSecurityGroupToSecurityGroup = novaSecurityGroupToSecurityGroup;
    }

    public org.jclouds.compute.domain.SecurityGroup createSecurityGroup(String name, Location location) {
        String region = location.getId();
        if (region == null) {
            return null;
        }
        this.logger.debug(">> creating security group %s in %s...", new Object[]{name, location});
        String markerGroup = this.namingConvention.create().sharedNameForGroup(name);
        RegionSecurityGroupNameAndPorts regionAndName = new RegionSecurityGroupNameAndPorts(region, markerGroup, (Iterable<Integer>)ImmutableSet.of());
        return (org.jclouds.compute.domain.SecurityGroup)this.groupCreator.getUnchecked((Object)regionAndName);
    }

    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroups() {
        HashSet securityGroups = Sets.newHashSet();
        for (String regionId : (Set)this.regionIds.get()) {
            Location location = (Location)((Map)this.locationIndex.get()).get(regionId);
            securityGroups.addAll(this.listSecurityGroupsInLocation(location));
        }
        return ImmutableSet.copyOf((Collection)securityGroups);
    }

    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsInLocation(Location location) {
        String region = location.getId();
        if (region == null) {
            return ImmutableSet.of();
        }
        return this.getSecurityGroupApi(region).listSecurityGroups().concat().transform((Function)this.neutronSecurityGroupToSecurityGroup.create(location)).toSet();
    }

    public Set<org.jclouds.compute.domain.SecurityGroup> listSecurityGroupsForNode(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        String region = regionAndId.getRegion();
        Location location = (Location)((Map)this.locationIndex.get()).get(region);
        Set<org.jclouds.openstack.nova.v2_0.domain.SecurityGroup> allGroups = this.api.getServerApi(region).listSecurityGroupForServer(regionAndId.getId());
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)Iterables.filter(allGroups, (Predicate)Predicates.notNull()), (Function)this.novaSecurityGroupToSecurityGroup.create(location)));
    }

    public org.jclouds.compute.domain.SecurityGroup getSecurityGroupById(String id) {
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded((String)Preconditions.checkNotNull((Object)id, (Object)"id"));
        String region = regionAndId.getRegion();
        String groupId = regionAndId.getId();
        SecurityGroupApi securityGroupApi = this.getSecurityGroupApi(region);
        Location location = (Location)((Map)this.locationIndex.get()).get(region);
        return this.neutronSecurityGroupToSecurityGroup.create(location).apply(securityGroupApi.getSecurityGroup(groupId));
    }

    public boolean removeSecurityGroup(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        RegionAndId regionAndId = RegionAndId.fromSlashEncoded(id);
        String region = regionAndId.getRegion();
        String groupId = regionAndId.getId();
        SecurityGroupApi securityGroupApi = this.getSecurityGroupApi(region);
        boolean deleted = securityGroupApi.deleteSecurityGroup(groupId);
        for (org.jclouds.compute.domain.SecurityGroup cachedSg : this.groupCreator.asMap().values()) {
            if (!id.equals(cachedSg.getId())) continue;
            String groupName = cachedSg.getName();
            this.groupCreator.invalidate((Object)new RegionSecurityGroupNameAndPorts(region, groupName, (Iterable<Integer>)ImmutableSet.of()));
            break;
        }
        return deleted;
    }

    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        String region = group.getLocation().getId();
        RegionAndId groupRegionAndId = RegionAndId.fromSlashEncoded(group.getId());
        String id = groupRegionAndId.getId();
        SecurityGroupApi securityGroupApi = this.getSecurityGroupApi(region);
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (String cidr : ipPermission.getCidrBlocks()) {
                securityGroupApi.create(((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)Rule.CreateRule.createBuilder((RuleDirection)RuleDirection.INGRESS, (String)group.getProviderId()).protocol(RuleProtocol.fromValue((String)ipPermission.getIpProtocol().name()))).ethertype(RuleEthertype.IPV4)).portRangeMin(Integer.valueOf(ipPermission.getFromPort()))).portRangeMax(Integer.valueOf(ipPermission.getToPort()))).remoteIpPrefix(cidr)).build());
            }
        }
        if (!ipPermission.getGroupIds().isEmpty()) {
            for (String regionAndGroupRaw : ipPermission.getGroupIds()) {
                RegionAndId regionAndId = RegionAndId.fromSlashEncoded(regionAndGroupRaw);
                String groupId = regionAndId.getId();
                securityGroupApi.create(((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)((Rule.CreateBuilder)Rule.CreateRule.createBuilder((RuleDirection)RuleDirection.INGRESS, (String)groupId).protocol(RuleProtocol.fromValue((String)ipPermission.getIpProtocol().name()))).ethertype(RuleEthertype.IPV4)).portRangeMin(Integer.valueOf(ipPermission.getFromPort()))).portRangeMax(Integer.valueOf(ipPermission.getToPort()))).remoteGroupId(groupId)).build());
            }
        }
        return this.getSecurityGroupById(RegionAndId.fromRegionAndId(region, id).slashEncode());
    }

    public org.jclouds.compute.domain.SecurityGroup addIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.addIpPermission(permBuilder.build(), group);
    }

    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(final IpPermission ipPermission, org.jclouds.compute.domain.SecurityGroup group) {
        String region = group.getLocation().getId();
        RegionAndId groupRegionAndId = RegionAndId.fromSlashEncoded(group.getId());
        String id = groupRegionAndId.getId();
        SecurityGroupApi securityGroupApi = this.getSecurityGroupApi(region);
        SecurityGroup securityGroup = securityGroupApi.getSecurityGroup(id);
        if (!ipPermission.getCidrBlocks().isEmpty()) {
            for (final String cidr : ipPermission.getCidrBlocks()) {
                for (Rule rule : Iterables.filter((Iterable)securityGroup.getRules(), (Predicate)new Predicate<Rule>(){

                    public boolean apply(@Nullable Rule input) {
                        return input.getRemoteIpPrefix() != null && input.getRemoteIpPrefix().equals(cidr) && input.getProtocol() != null && input.getProtocol().name().equals(ipPermission.getIpProtocol().name()) && input.getPortRangeMin() != null && input.getPortRangeMin().intValue() == ipPermission.getFromPort() && input.getPortRangeMax() != null && input.getPortRangeMax().intValue() == ipPermission.getToPort();
                    }
                })) {
                    securityGroupApi.deleteRule(rule.getId());
                }
            }
        }
        if (!ipPermission.getGroupIds().isEmpty()) {
            for (final String groupId : ipPermission.getGroupIds()) {
                for (Rule rule : Iterables.filter((Iterable)securityGroup.getRules(), (Predicate)new Predicate<Rule>(){

                    public boolean apply(@Nullable Rule input) {
                        return input.getRemoteGroupId() != null && input.getRemoteGroupId().equals(groupId) && input.getProtocol() != null && input.getProtocol().name().equals(ipPermission.getIpProtocol().name()) && input.getPortRangeMin() != null && input.getPortRangeMin().intValue() == ipPermission.getFromPort() && input.getPortRangeMax() != null && input.getPortRangeMax().intValue() == ipPermission.getToPort();
                    }
                })) {
                    securityGroupApi.deleteRule(rule.getId());
                }
            }
        }
        return this.getSecurityGroupById(RegionAndId.fromRegionAndId(region, id).slashEncode());
    }

    public org.jclouds.compute.domain.SecurityGroup removeIpPermission(IpProtocol protocol, int startPort, int endPort, Multimap<String, String> tenantIdGroupNamePairs, Iterable<String> ipRanges, Iterable<String> groupIds, org.jclouds.compute.domain.SecurityGroup group) {
        IpPermission.Builder permBuilder = IpPermission.builder();
        permBuilder.ipProtocol(protocol);
        permBuilder.fromPort(startPort);
        permBuilder.toPort(endPort);
        permBuilder.tenantIdGroupNamePairs(tenantIdGroupNamePairs);
        permBuilder.cidrBlocks(ipRanges);
        permBuilder.groupIds(groupIds);
        return this.removeIpPermission(permBuilder.build(), group);
    }

    public boolean supportsTenantIdGroupNamePairs() {
        return false;
    }

    public boolean supportsTenantIdGroupIdPairs() {
        return false;
    }

    public boolean supportsGroupIds() {
        return true;
    }

    public boolean supportsPortRangesForGroups() {
        return false;
    }

    public boolean supportsExclusionCidrBlocks() {
        return false;
    }

    private SecurityGroupApi getSecurityGroupApi(String region) {
        return ((NeutronApi)((ApiContext)((Context)this.neutronContextSupplier.get())).getApi()).getSecurityGroupApi(region);
    }
}

