/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotFeatureInfo;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;

public final class SnapshotInfo
implements Comparable<SnapshotInfo>,
ToXContentFragment,
Writeable {
    public static final Version DATA_STREAMS_IN_SNAPSHOT = Version.V_7_9_0;
    public static final Version METADATA_FIELD_INTRODUCED = Version.V_7_3_0;
    public static final String INDEX_DETAILS_XCONTENT_PARAM = "index_details";
    public static final String INCLUDE_REPOSITORY_XCONTENT_PARAM = "include_repository";
    private static final DateFormatter DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time");
    private static final String SNAPSHOT = "snapshot";
    private static final String UUID = "uuid";
    private static final String REPOSITORY = "repository";
    private static final String INDICES = "indices";
    private static final String DATA_STREAMS = "data_streams";
    private static final String STATE = "state";
    private static final String REASON = "reason";
    private static final String START_TIME = "start_time";
    private static final String START_TIME_IN_MILLIS = "start_time_in_millis";
    private static final String END_TIME = "end_time";
    private static final String END_TIME_IN_MILLIS = "end_time_in_millis";
    private static final String DURATION = "duration";
    private static final String DURATION_IN_MILLIS = "duration_in_millis";
    private static final String FAILURES = "failures";
    private static final String SHARDS = "shards";
    private static final String TOTAL = "total";
    private static final String FAILED = "failed";
    private static final String SUCCESSFUL = "successful";
    private static final String VERSION_ID = "version_id";
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String TOTAL_SHARDS = "total_shards";
    private static final String SUCCESSFUL_SHARDS = "successful_shards";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    private static final String USER_METADATA = "metadata";
    private static final String FEATURE_STATES = "feature_states";
    private static final String INDEX_DETAILS = "index_details";
    private static final String UNKNOWN_REPO_NAME = "_na_";
    private static final Comparator<SnapshotInfo> COMPARATOR = Comparator.comparing(SnapshotInfo::startTime).thenComparing(SnapshotInfo::snapshotId);
    public static final ObjectParser<SnapshotInfoBuilder, Void> SNAPSHOT_INFO_PARSER = new ObjectParser(SnapshotInfoBuilder.class.getName(), true, SnapshotInfoBuilder::new);
    private static final ObjectParser<ShardStatsBuilder, Void> SHARD_STATS_PARSER = new ObjectParser(ShardStatsBuilder.class.getName(), true, () -> new ShardStatsBuilder());
    private final Snapshot snapshot;
    @Nullable
    private final SnapshotState state;
    @Nullable
    private final String reason;
    private final List<String> indices;
    private final List<String> dataStreams;
    private final List<SnapshotFeatureInfo> featureStates;
    private final long startTime;
    private final long endTime;
    private final int totalShards;
    private final int successfulShards;
    @Nullable
    private final Boolean includeGlobalState;
    @Nullable
    private final Map<String, Object> userMetadata;
    @Nullable
    private final Version version;
    private final List<SnapshotShardFailure> shardFailures;
    private final Map<String, IndexSnapshotDetails> indexSnapshotDetails;

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, SnapshotState state) {
        this(snapshot, indices, dataStreams, featureStates, null, null, 0L, 0L, 0, 0, Collections.emptyList(), null, null, state, Collections.emptyMap());
    }

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, Version version, SnapshotState state) {
        this(snapshot, indices, dataStreams, featureStates, null, version, 0L, 0L, 0, 0, Collections.emptyList(), null, null, state, Collections.emptyMap());
    }

    public SnapshotInfo(SnapshotsInProgress.Entry entry) {
        this(entry.snapshot(), org.elasticsearch.core.List.copyOf(entry.indices().keySet()), entry.dataStreams(), entry.featureStates(), null, Version.CURRENT, entry.startTime(), 0L, 0, 0, Collections.emptyList(), entry.includeGlobalState(), entry.userMetadata(), SnapshotState.IN_PROGRESS, Collections.emptyMap());
    }

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, String reason, long endTime, int totalShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState, Map<String, Object> userMetadata, long startTime, Map<String, IndexSnapshotDetails> indexSnapshotDetails) {
        this(snapshot, indices, dataStreams, featureStates, reason, Version.CURRENT, startTime, endTime, totalShards, totalShards - shardFailures.size(), shardFailures, includeGlobalState, userMetadata, SnapshotInfo.snapshotState(reason, shardFailures), indexSnapshotDetails);
    }

    public SnapshotInfo(Snapshot snapshot, List<String> indices, List<String> dataStreams, List<SnapshotFeatureInfo> featureStates, String reason, Version version, long startTime, long endTime, int totalShards, int successfulShards, List<SnapshotShardFailure> shardFailures, Boolean includeGlobalState, Map<String, Object> userMetadata, SnapshotState state, Map<String, IndexSnapshotDetails> indexSnapshotDetails) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.indices = org.elasticsearch.core.List.copyOf(indices);
        this.dataStreams = org.elasticsearch.core.List.copyOf(dataStreams);
        this.featureStates = org.elasticsearch.core.List.copyOf(featureStates);
        this.state = state;
        this.reason = reason;
        this.version = version;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.shardFailures = org.elasticsearch.core.List.copyOf(shardFailures);
        this.includeGlobalState = includeGlobalState;
        this.userMetadata = userMetadata == null ? null : org.elasticsearch.core.Map.copyOf(userMetadata);
        this.indexSnapshotDetails = org.elasticsearch.core.Map.copyOf(indexSnapshotDetails);
    }

    public static SnapshotInfo readFrom(StreamInput in) throws IOException {
        Snapshot snapshot = in.getVersion().onOrAfter(GetSnapshotsRequest.PAGINATED_GET_SNAPSHOTS_VERSION) ? new Snapshot(in) : new Snapshot(UNKNOWN_REPO_NAME, new SnapshotId(in));
        List<String> indices = in.readStringList();
        SnapshotState state = in.readBoolean() ? SnapshotState.fromValue(in.readByte()) : null;
        String reason = in.readOptionalString();
        long startTime = in.readVLong();
        long endTime = in.readVLong();
        int totalShards = in.readVInt();
        int successfulShards = in.readVInt();
        List<SnapshotShardFailure> shardFailures = in.readList(SnapshotShardFailure::new);
        Version version = in.readBoolean() ? Version.readVersion(in) : null;
        Boolean includeGlobalState = in.readOptionalBoolean();
        Map<String, Object> userMetadata = in.getVersion().onOrAfter(METADATA_FIELD_INTRODUCED) ? in.readMap() : null;
        List<String> dataStreams = in.getVersion().onOrAfter(DATA_STREAMS_IN_SNAPSHOT) ? in.readStringList() : Collections.emptyList();
        List<Object> featureStates = in.getVersion().before(SnapshotsService.FEATURE_STATES_VERSION) ? Collections.emptyList() : Collections.unmodifiableList(in.readList(SnapshotFeatureInfo::new));
        Map<String, IndexSnapshotDetails> indexSnapshotDetails = in.getVersion().onOrAfter(SnapshotsService.INDEX_DETAILS_INTRODUCED) ? in.readMap(StreamInput::readString, IndexSnapshotDetails::new) : Collections.emptyMap();
        return new SnapshotInfo(snapshot, indices, dataStreams, featureStates, reason, version, startTime, endTime, totalShards, successfulShards, shardFailures, includeGlobalState, userMetadata, state, indexSnapshotDetails);
    }

    public SnapshotInfo basic() {
        return new SnapshotInfo(this.snapshot, this.indices, Collections.emptyList(), this.featureStates, this.state);
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public SnapshotId snapshotId() {
        return this.snapshot.getSnapshotId();
    }

    public String repository() {
        return this.snapshot.getRepository();
    }

    @Nullable
    public SnapshotState state() {
        return this.state;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    public List<String> indices() {
        return this.indices;
    }

    public List<String> dataStreams() {
        return this.dataStreams;
    }

    public long startTime() {
        return this.startTime;
    }

    public long endTime() {
        return this.endTime;
    }

    public int totalShards() {
        return this.totalShards;
    }

    public int failedShards() {
        return this.totalShards - this.successfulShards;
    }

    public int successfulShards() {
        return this.successfulShards;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    @Nullable
    public Version version() {
        return this.version;
    }

    @Nullable
    public Map<String, Object> userMetadata() {
        return this.userMetadata;
    }

    public List<SnapshotFeatureInfo> featureStates() {
        return this.featureStates;
    }

    public Map<String, IndexSnapshotDetails> indexSnapshotDetails() {
        return this.indexSnapshotDetails;
    }

    @Override
    public int compareTo(SnapshotInfo o) {
        return COMPARATOR.compare(this, o);
    }

    public String toString() {
        return "SnapshotInfo{snapshot=" + this.snapshot + ", state=" + (Object)((Object)this.state) + ", reason='" + this.reason + '\'' + ", indices=" + this.indices + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", totalShards=" + this.totalShards + ", successfulShards=" + this.successfulShards + ", includeGlobalState=" + this.includeGlobalState + ", version=" + this.version + ", shardFailures=" + this.shardFailures + ", featureStates=" + this.featureStates + ", indexSnapshotDetails=" + this.indexSnapshotDetails + '}';
    }

    public RestStatus status() {
        if (this.state == SnapshotState.FAILED) {
            return RestStatus.INTERNAL_SERVER_ERROR;
        }
        if (this.shardFailures.size() == 0) {
            return RestStatus.OK;
        }
        return RestStatus.status(this.successfulShards, this.totalShards, this.shardFailures.toArray(new ShardOperationFailedException[this.shardFailures.size()]));
    }

    public XContentBuilder toXContentExternal(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (!Metadata.CONTEXT_MODE_SNAPSHOT.equals(params.param("context_mode"))) : "use toXContent() in SNAPSHOT context";
        boolean verbose = params.paramAsBoolean("verbose", true);
        builder.startObject();
        SnapshotId snapshotId = this.snapshot.getSnapshotId();
        builder.field(SNAPSHOT, snapshotId.getName());
        builder.field(UUID, snapshotId.getUUID());
        if (params.paramAsBoolean(INCLUDE_REPOSITORY_XCONTENT_PARAM, true) && !UNKNOWN_REPO_NAME.equals(this.snapshot.getRepository())) {
            builder.field(REPOSITORY, this.snapshot.getRepository());
        }
        if (this.version != null) {
            builder.field(VERSION_ID, this.version.id);
            builder.field(VERSION, this.version.toString());
        }
        builder.startArray(INDICES);
        for (String string : this.indices) {
            builder.value(string);
        }
        builder.endArray();
        if (params.paramAsBoolean("index_details", false) && !this.indexSnapshotDetails.isEmpty()) {
            builder.startObject("index_details");
            for (Map.Entry entry : this.indexSnapshotDetails.entrySet()) {
                builder.field((String)entry.getKey());
                ((IndexSnapshotDetails)entry.getValue()).toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.startArray(DATA_STREAMS);
        for (String string : this.dataStreams) {
            builder.value(string);
        }
        builder.endArray();
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        if (this.userMetadata != null) {
            builder.field(USER_METADATA, this.userMetadata);
        }
        if (verbose || this.state != null) {
            builder.field(STATE, (Object)this.state);
        }
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        if (verbose || this.startTime != 0L) {
            builder.field(START_TIME, DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.startTime).atZone(ZoneOffset.UTC)));
            builder.field(START_TIME_IN_MILLIS, this.startTime);
        }
        if (verbose || this.endTime != 0L) {
            builder.field(END_TIME, DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(this.endTime).atZone(ZoneOffset.UTC)));
            builder.field(END_TIME_IN_MILLIS, this.endTime);
            builder.humanReadableField(DURATION_IN_MILLIS, DURATION, (Object)new TimeValue(Math.max(0L, this.endTime - this.startTime)));
        }
        if (verbose || !this.shardFailures.isEmpty()) {
            builder.startArray(FAILURES);
            for (SnapshotShardFailure snapshotShardFailure : this.shardFailures) {
                snapshotShardFailure.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (verbose || this.totalShards != 0) {
            builder.startObject(SHARDS);
            builder.field(TOTAL, this.totalShards);
            builder.field(FAILED, this.failedShards());
            builder.field(SUCCESSFUL, this.successfulShards);
            builder.endObject();
        }
        if (verbose || !this.featureStates.isEmpty()) {
            builder.startArray(FEATURE_STATES);
            for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
                builder.value((Object)snapshotFeatureInfo);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        assert (Metadata.CONTEXT_MODE_SNAPSHOT.equals(params.param("context_mode"))) : "use toXContentExternal() in external context";
        builder.startObject(SNAPSHOT);
        SnapshotId snapshotId = this.snapshot.getSnapshotId();
        builder.field(NAME, snapshotId.getName());
        builder.field(UUID, snapshotId.getUUID());
        assert (this.version != null) : "version must always be known when writing a snapshot metadata blob";
        builder.field(VERSION_ID, this.version.id);
        builder.startArray(INDICES);
        for (String string : this.indices) {
            builder.value(string);
        }
        builder.endArray();
        builder.startArray(DATA_STREAMS);
        for (String string : this.dataStreams) {
            builder.value(string);
        }
        builder.endArray();
        builder.field(STATE, (Object)this.state);
        if (this.reason != null) {
            builder.field(REASON, this.reason);
        }
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        if (this.userMetadata != null) {
            builder.field(USER_METADATA, this.userMetadata);
        }
        builder.field(START_TIME, this.startTime);
        builder.field(END_TIME, this.endTime);
        builder.field(TOTAL_SHARDS, this.totalShards);
        builder.field(SUCCESSFUL_SHARDS, this.successfulShards);
        builder.startArray(FAILURES);
        for (SnapshotShardFailure snapshotShardFailure : this.shardFailures) {
            snapshotShardFailure.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray(FEATURE_STATES);
        for (SnapshotFeatureInfo snapshotFeatureInfo : this.featureStates) {
            builder.value((Object)snapshotFeatureInfo);
        }
        builder.endArray();
        builder.startObject("index_details");
        for (Map.Entry entry : this.indexSnapshotDetails.entrySet()) {
            builder.field((String)entry.getKey());
            ((IndexSnapshotDetails)entry.getValue()).toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static SnapshotInfo fromXContentInternal(String repoName, XContentParser parser) throws IOException {
        String name = null;
        String uuid = null;
        Version version = Version.CURRENT;
        SnapshotState state = SnapshotState.IN_PROGRESS;
        String reason = null;
        List<String> indices = Collections.emptyList();
        List<String> dataStreams = Collections.emptyList();
        long startTime = 0L;
        long endTime = 0L;
        int totalShards = 0;
        int successfulShards = 0;
        Boolean includeGlobalState = null;
        Map userMetadata = null;
        List<SnapshotShardFailure> shardFailures = Collections.emptyList();
        List<SnapshotFeatureInfo> featureStates = Collections.emptyList();
        Map indexSnapshotDetails = null;
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.nextToken();
        }
        XContentParserUtils.ensureFieldName(parser, parser.currentToken(), SNAPSHOT);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        block36: while (parser.nextToken() == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            XContentParser.Token token = parser.nextToken();
            switch (currentFieldName) {
                case "name": {
                    name = parser.text();
                    continue block36;
                }
                case "uuid": {
                    uuid = parser.text();
                    continue block36;
                }
                case "state": {
                    state = SnapshotState.valueOf(parser.text());
                    continue block36;
                }
                case "reason": {
                    reason = parser.text();
                    continue block36;
                }
                case "start_time": {
                    startTime = parser.longValue();
                    continue block36;
                }
                case "end_time": {
                    endTime = parser.longValue();
                    continue block36;
                }
                case "total_shards": {
                    totalShards = parser.intValue();
                    continue block36;
                }
                case "successful_shards": {
                    successfulShards = parser.intValue();
                    continue block36;
                }
                case "version_id": {
                    version = Version.fromId(parser.intValue());
                    continue block36;
                }
                case "include_global_state": {
                    includeGlobalState = parser.booleanValue();
                    continue block36;
                }
                case "data_streams": {
                    dataStreams = XContentParserUtils.parseList(parser, XContentParser::text);
                    continue block36;
                }
                case "indices": {
                    indices = XContentParserUtils.parseList(parser, XContentParser::text);
                    continue block36;
                }
                case "failures": {
                    shardFailures = XContentParserUtils.parseList(parser, SnapshotShardFailure::fromXContent);
                    continue block36;
                }
                case "feature_states": {
                    featureStates = XContentParserUtils.parseList(parser, SnapshotFeatureInfo::fromXContent);
                    continue block36;
                }
                case "metadata": {
                    if (token == XContentParser.Token.VALUE_NULL) continue block36;
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                    userMetadata = parser.map();
                    continue block36;
                }
                case "index_details": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                    indexSnapshotDetails = parser.map(HashMap::new, p -> (IndexSnapshotDetails)IndexSnapshotDetails.PARSER.parse(p, null));
                    continue block36;
                }
            }
            parser.skipChildren();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        if (uuid == null) {
            uuid = name;
        }
        return new SnapshotInfo(new Snapshot(repoName, new SnapshotId(name, uuid)), indices, dataStreams, featureStates, reason, version, startTime, endTime, totalShards, successfulShards, shardFailures, includeGlobalState, userMetadata, state, indexSnapshotDetails == null ? Collections.emptyMap() : indexSnapshotDetails);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(GetSnapshotsRequest.PAGINATED_GET_SNAPSHOTS_VERSION)) {
            this.snapshot.writeTo(out);
        } else {
            this.snapshot.getSnapshotId().writeTo(out);
        }
        out.writeStringCollection(this.indices);
        if (this.state != null) {
            out.writeBoolean(true);
            out.writeByte(this.state.value());
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalString(this.reason);
        out.writeVLong(this.startTime);
        out.writeVLong(this.endTime);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeList(this.shardFailures);
        if (this.version != null) {
            out.writeBoolean(true);
            Version.writeVersion(this.version, out);
        } else {
            out.writeBoolean(false);
        }
        out.writeOptionalBoolean(this.includeGlobalState);
        if (out.getVersion().onOrAfter(METADATA_FIELD_INTRODUCED)) {
            out.writeMap(this.userMetadata);
        }
        if (out.getVersion().onOrAfter(DATA_STREAMS_IN_SNAPSHOT)) {
            out.writeStringCollection(this.dataStreams);
        }
        if (out.getVersion().onOrAfter(SnapshotsService.FEATURE_STATES_VERSION)) {
            out.writeList(this.featureStates);
        }
        if (out.getVersion().onOrAfter(SnapshotsService.INDEX_DETAILS_INTRODUCED)) {
            out.writeMap(this.indexSnapshotDetails, StreamOutput::writeString, (stream, value) -> value.writeTo(stream));
        }
    }

    private static SnapshotState snapshotState(String reason, List<SnapshotShardFailure> shardFailures) {
        if (reason == null) {
            if (shardFailures.isEmpty()) {
                return SnapshotState.SUCCESS;
            }
            return SnapshotState.PARTIAL;
        }
        return SnapshotState.FAILED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotInfo that = (SnapshotInfo)o;
        return this.startTime == that.startTime && this.endTime == that.endTime && this.totalShards == that.totalShards && this.successfulShards == that.successfulShards && Objects.equals(this.snapshot, that.snapshot) && this.state == that.state && Objects.equals(this.reason, that.reason) && Objects.equals(this.indices, that.indices) && Objects.equals(this.dataStreams, that.dataStreams) && Objects.equals(this.includeGlobalState, that.includeGlobalState) && Objects.equals(this.version, that.version) && Objects.equals(this.shardFailures, that.shardFailures) && Objects.equals(this.userMetadata, that.userMetadata) && Objects.equals(this.featureStates, that.featureStates) && Objects.equals(this.indexSnapshotDetails, that.indexSnapshotDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshot, this.state, this.reason, this.indices, this.dataStreams, this.startTime, this.endTime, this.totalShards, this.successfulShards, this.includeGlobalState, this.version, this.shardFailures, this.userMetadata, this.featureStates, this.indexSnapshotDetails});
    }

    static {
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setSnapshotName(x$0), new ParseField(SNAPSHOT, new String[0]));
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setSnapshotUUID(x$0), new ParseField(UUID, new String[0]));
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setRepository(x$0), new ParseField(REPOSITORY, new String[0]));
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setState(x$0), new ParseField(STATE, new String[0]));
        SNAPSHOT_INFO_PARSER.declareString((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setReason(x$0), new ParseField(REASON, new String[0]));
        SNAPSHOT_INFO_PARSER.declareStringArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setIndices(x$0), new ParseField(INDICES, new String[0]));
        SNAPSHOT_INFO_PARSER.declareStringArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setDataStreams(x$0), new ParseField(DATA_STREAMS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObjectArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setFeatureStates(x$0), SnapshotFeatureInfo.SNAPSHOT_FEATURE_INFO_PARSER, new ParseField(FEATURE_STATES, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setIndexSnapshotDetails(x$0), (p, c) -> p.map(HashMap::new, p2 -> (IndexSnapshotDetails)IndexSnapshotDetails.PARSER.parse(p2, c)), new ParseField("index_details", new String[0]));
        SNAPSHOT_INFO_PARSER.declareLong((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setStartTime(x$0), new ParseField(START_TIME_IN_MILLIS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareLong((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setEndTime(x$0), new ParseField(END_TIME_IN_MILLIS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setShardStatsBuilder(x$0), SHARD_STATS_PARSER, new ParseField(SHARDS, new String[0]));
        SNAPSHOT_INFO_PARSER.declareBoolean((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setIncludeGlobalState(x$0), new ParseField(INCLUDE_GLOBAL_STATE, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObject((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setUserMetadata(x$0), (p, c) -> p.map(), new ParseField(USER_METADATA, new String[0]));
        SNAPSHOT_INFO_PARSER.declareInt((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setVersion(x$0), new ParseField(VERSION_ID, new String[0]));
        SNAPSHOT_INFO_PARSER.declareObjectArray((rec$, x$0) -> ((SnapshotInfoBuilder)rec$).setShardFailures(x$0), SnapshotShardFailure.SNAPSHOT_SHARD_FAILURE_PARSER, new ParseField(FAILURES, new String[0]));
        SHARD_STATS_PARSER.declareInt((rec$, x$0) -> ((ShardStatsBuilder)rec$).setTotalShards(x$0), new ParseField(TOTAL, new String[0]));
        SHARD_STATS_PARSER.declareInt((rec$, x$0) -> ((ShardStatsBuilder)rec$).setSuccessfulShards(x$0), new ParseField(SUCCESSFUL, new String[0]));
    }

    public static class IndexSnapshotDetails
    implements ToXContentObject,
    Writeable {
        private static final String SHARD_COUNT = "shard_count";
        private static final String SIZE = "size_in_bytes";
        private static final String MAX_SEGMENTS_PER_SHARD = "max_segments_per_shard";
        public static final IndexSnapshotDetails SKIPPED = new IndexSnapshotDetails(0, ByteSizeValue.ZERO, 0);
        public static final ConstructingObjectParser<IndexSnapshotDetails, Void> PARSER = new ConstructingObjectParser(IndexSnapshotDetails.class.getName(), true, a -> new IndexSnapshotDetails((Integer)a[0], ByteSizeValue.ofBytes((Long)a[1]), (Integer)a[2]));
        private final int shardCount;
        private final ByteSizeValue size;
        private final int maxSegmentsPerShard;

        public IndexSnapshotDetails(int shardCount, ByteSizeValue size, int maxSegmentsPerShard) {
            this.shardCount = shardCount;
            this.size = Objects.requireNonNull(size);
            this.maxSegmentsPerShard = maxSegmentsPerShard;
        }

        public IndexSnapshotDetails(StreamInput in) throws IOException {
            this.shardCount = in.readVInt();
            this.size = new ByteSizeValue(in);
            this.maxSegmentsPerShard = in.readVInt();
        }

        public int getShardCount() {
            return this.shardCount;
        }

        public ByteSizeValue getSize() {
            return this.size;
        }

        public int getMaxSegmentsPerShard() {
            return this.maxSegmentsPerShard;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexSnapshotDetails that = (IndexSnapshotDetails)o;
            return this.shardCount == that.shardCount && this.maxSegmentsPerShard == that.maxSegmentsPerShard && this.size.equals(that.size);
        }

        public int hashCode() {
            return Objects.hash(this.shardCount, this.size, this.maxSegmentsPerShard);
        }

        public String toString() {
            return "IndexSnapshotDetails{shardCount=" + this.shardCount + ", size=" + this.size + ", maxSegmentsPerShard=" + this.maxSegmentsPerShard + '}';
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.shardCount);
            this.size.writeTo(out);
            out.writeVInt(this.maxSegmentsPerShard);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(SHARD_COUNT, this.shardCount);
            builder.humanReadableField(SIZE, "size", (Object)this.size);
            builder.field(MAX_SEGMENTS_PER_SHARD, this.maxSegmentsPerShard);
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(SHARD_COUNT, new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField(SIZE, new String[0]));
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), new ParseField(MAX_SEGMENTS_PER_SHARD, new String[0]));
        }
    }

    private static final class ShardStatsBuilder {
        private int totalShards;
        private int successfulShards;

        private ShardStatsBuilder() {
        }

        private void setTotalShards(int totalShards) {
            this.totalShards = totalShards;
        }

        int getTotalShards() {
            return this.totalShards;
        }

        private void setSuccessfulShards(int successfulShards) {
            this.successfulShards = successfulShards;
        }

        int getSuccessfulShards() {
            return this.successfulShards;
        }
    }

    public static final class SnapshotInfoBuilder {
        private String snapshotName = null;
        private String snapshotUUID = null;
        private String repository = "_na_";
        private String state = null;
        private String reason = null;
        private List<String> indices = null;
        private List<String> dataStreams = null;
        private List<SnapshotFeatureInfo> featureStates = null;
        private Map<String, IndexSnapshotDetails> indexSnapshotDetails = null;
        private long startTime = 0L;
        private long endTime = 0L;
        private ShardStatsBuilder shardStatsBuilder = null;
        private Boolean includeGlobalState = null;
        private Map<String, Object> userMetadata = null;
        private int version = -1;
        private List<SnapshotShardFailure> shardFailures = null;

        private void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        private void setSnapshotUUID(String snapshotUUID) {
            this.snapshotUUID = snapshotUUID;
        }

        private void setRepository(String repository) {
            this.repository = repository;
        }

        private void setState(String state) {
            this.state = state;
        }

        private void setReason(String reason) {
            this.reason = reason;
        }

        private void setIndices(List<String> indices) {
            this.indices = indices;
        }

        private void setDataStreams(List<String> dataStreams) {
            this.dataStreams = dataStreams;
        }

        private void setFeatureStates(List<SnapshotFeatureInfo> featureStates) {
            this.featureStates = featureStates;
        }

        private void setIndexSnapshotDetails(Map<String, IndexSnapshotDetails> indexSnapshotDetails) {
            this.indexSnapshotDetails = indexSnapshotDetails;
        }

        private void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        private void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        private void setShardStatsBuilder(ShardStatsBuilder shardStatsBuilder) {
            this.shardStatsBuilder = shardStatsBuilder;
        }

        private void setIncludeGlobalState(Boolean includeGlobalState) {
            this.includeGlobalState = includeGlobalState;
        }

        private void setUserMetadata(Map<String, Object> userMetadata) {
            this.userMetadata = userMetadata;
        }

        private void setVersion(int version) {
            this.version = version;
        }

        private void setShardFailures(List<SnapshotShardFailure> shardFailures) {
            this.shardFailures = shardFailures;
        }

        public SnapshotInfo build() {
            int successfulShards;
            Snapshot snapshot = new Snapshot(this.repository, new SnapshotId(this.snapshotName, this.snapshotUUID));
            if (this.indices == null) {
                this.indices = Collections.emptyList();
            }
            if (this.dataStreams == null) {
                this.dataStreams = Collections.emptyList();
            }
            if (this.featureStates == null) {
                this.featureStates = Collections.emptyList();
            }
            if (this.indexSnapshotDetails == null) {
                this.indexSnapshotDetails = Collections.emptyMap();
            }
            SnapshotState snapshotState = this.state == null ? null : SnapshotState.valueOf(this.state);
            Version version = this.version == -1 ? Version.CURRENT : Version.fromId(this.version);
            int totalShards = this.shardStatsBuilder == null ? 0 : this.shardStatsBuilder.getTotalShards();
            int n = successfulShards = this.shardStatsBuilder == null ? 0 : this.shardStatsBuilder.getSuccessfulShards();
            if (this.shardFailures == null) {
                this.shardFailures = new ArrayList<SnapshotShardFailure>();
            }
            return new SnapshotInfo(snapshot, this.indices, this.dataStreams, this.featureStates, this.reason, version, this.startTime, this.endTime, totalShards, successfulShards, this.shardFailures, this.includeGlobalState, this.userMetadata, snapshotState, this.indexSnapshotDetails);
        }
    }
}

