/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;

public class ParsedDoubleTerms
extends ParsedTerms {
    private static final ObjectParser<ParsedDoubleTerms, Void> PARSER = new ObjectParser(ParsedDoubleTerms.class.getSimpleName(), true, ParsedDoubleTerms::new);

    @Override
    public String getType() {
        return "dterms";
    }

    public static ParsedDoubleTerms fromXContent(XContentParser parser, String name) throws IOException {
        ParsedDoubleTerms aggregation = (ParsedDoubleTerms)PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedDoubleTerms.declareParsedTermsFields(PARSER, (CheckedFunction<XContentParser, ParsedTerms.ParsedBucket, IOException>)((CheckedFunction)ParsedBucket::fromXContent));
    }

    public static class ParsedBucket
    extends ParsedTerms.ParsedBucket {
        private Double key;

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Double.toString(this.key);
            }
            return null;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.key;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            if (super.getKeyAsString() != null) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            }
            return builder;
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseTermsBucketXContent(parser, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.doubleValue();
            });
        }
    }
}

