/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DiversifiedTopDocsCollector;
import org.apache.lucene.search.TopDocsCollector;
import org.elasticsearch.index.fielddata.AbstractNumericDocValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class DiversifiedOrdinalsSamplerAggregator
extends SamplerAggregator {
    private ValuesSource.Bytes.WithOrdinals.FieldData valuesSource;
    private int maxDocsPerValue;

    DiversifiedOrdinalsSamplerAggregator(String name, int shardSize, AggregatorFactories factories, AggregationContext context, Aggregator parent, Map<String, Object> metadata, ValuesSourceConfig valuesSourceConfig, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSourceConfig.getValuesSource();
        this.maxDocsPerValue = maxDocsPerValue;
    }

    @Override
    public DeferringBucketCollector buildDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector(x$0 -> this.addRequestCircuitBreakerBytes((long)x$0));
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector(Consumer<Long> circuitBreakerConsumer) {
            super(DiversifiedOrdinalsSamplerAggregator.this.shardSize, DiversifiedOrdinalsSamplerAggregator.this.bigArrays(), circuitBreakerConsumer);
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            int minMaxDocsPerValue = Math.min(DiversifiedOrdinalsSamplerAggregator.this.maxDocsPerValue, DiversifiedOrdinalsSamplerAggregator.this.searcher().getIndexReader().maxDoc());
            return new ValuesDiversifiedTopDocsCollector(size, minMaxDocsPerValue);
        }

        @Override
        protected long getPriorityQueueSlotSize() {
            return SamplerAggregator.SCOREDOCKEY_SIZE;
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            protected NumericDocValues getKeys(LeafReaderContext context) {
                final SortedSetDocValues globalOrds = DiversifiedOrdinalsSamplerAggregator.this.valuesSource.globalOrdinalsValues(context);
                final SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)globalOrds);
                if (singleValues != null) {
                    return new AbstractNumericDocValues(){

                        public boolean advanceExact(int target) throws IOException {
                            return singleValues.advanceExact(target);
                        }

                        public int docID() {
                            return singleValues.docID();
                        }

                        public long longValue() throws IOException {
                            return singleValues.ordValue();
                        }
                    };
                }
                return new AbstractNumericDocValues(){
                    long value;

                    public boolean advanceExact(int target) throws IOException {
                        if (globalOrds.advanceExact(target)) {
                            this.value = globalOrds.nextOrd();
                            if (globalOrds.nextOrd() != -1L) {
                                throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                            }
                            return true;
                        }
                        return false;
                    }

                    public int docID() {
                        return globalOrds.docID();
                    }

                    public long longValue() throws IOException {
                        return this.value;
                    }
                };
            }
        }
    }
}

