/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySnapshotFileRequest;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RemoteRecoveryTargetHandler
implements RecoveryTargetHandler {
    private static final Logger logger = LogManager.getLogger(RemoteRecoveryTargetHandler.class);
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final long recoveryId;
    private final ShardId shardId;
    private final DiscoveryNode targetNode;
    private final RecoverySettings recoverySettings;
    private final Map<Object, RetryableAction<?>> onGoingRetryableActions = ConcurrentCollections.newConcurrentMap();
    private final TransportRequestOptions translogOpsRequestOptions;
    private final TransportRequestOptions fileChunkRequestOptions;
    private final TransportRequestOptions standardTimeoutRequestOptions;
    private final AtomicLong bytesSinceLastPause = new AtomicLong();
    private final AtomicLong requestSeqNoGenerator = new AtomicLong(0L);
    private final Consumer<Long> onSourceThrottle;
    private final boolean retriesSupported;
    private volatile boolean isCancelled = false;

    public RemoteRecoveryTargetHandler(long recoveryId, ShardId shardId, TransportService transportService, DiscoveryNode targetNode, RecoverySettings recoverySettings, Consumer<Long> onSourceThrottle) {
        this.transportService = transportService;
        this.threadPool = transportService.getThreadPool();
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetNode = targetNode;
        this.recoverySettings = recoverySettings;
        this.onSourceThrottle = onSourceThrottle;
        this.translogOpsRequestOptions = TransportRequestOptions.of(recoverySettings.internalActionLongTimeout(), TransportRequestOptions.Type.RECOVERY);
        this.fileChunkRequestOptions = TransportRequestOptions.of(recoverySettings.internalActionTimeout(), TransportRequestOptions.Type.RECOVERY);
        this.standardTimeoutRequestOptions = TransportRequestOptions.timeout(recoverySettings.internalActionTimeout());
        this.retriesSupported = targetNode.getVersion().onOrAfter(Version.V_7_9_0);
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    @Override
    public void prepareForTranslogOperations(int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/prepare_translog";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryPrepareForTranslogOperationsRequest request = new RecoveryPrepareForTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, totalTranslogOps);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        this.executeRetryableAction("internal:index/shard/recovery/prepare_translog", request, this.standardTimeoutRequestOptions, listener.map(r -> null), reader);
    }

    @Override
    public void finalizeRecovery(long globalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/finalize";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFinalizeRecoveryRequest request = new RecoveryFinalizeRecoveryRequest(this.recoveryId, requestSeqNo, this.shardId, globalCheckpoint, trimAboveSeqNo);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        this.executeRetryableAction("internal:index/shard/recovery/finalize", request, TransportRequestOptions.timeout(this.recoverySettings.internalActionLongTimeout()), listener.map(r -> null), reader);
    }

    @Override
    public void handoffPrimaryContext(ReplicationTracker.PrimaryContext primaryContext, ActionListener<Void> listener) {
        this.transportService.sendRequest(this.targetNode, "internal:index/shard/recovery/handoff_primary_context", (TransportRequest)new RecoveryHandoffPrimaryContextRequest(this.recoveryId, this.shardId, primaryContext), this.standardTimeoutRequestOptions, new ActionListenerResponseHandler<TransportResponse.Empty>(listener.map(r -> null), in -> TransportResponse.Empty.INSTANCE, "generic"));
    }

    @Override
    public void indexTranslogOperations(List<Translog.Operation> operations, int totalTranslogOps, long maxSeenAutoIdTimestampOnPrimary, long maxSeqNoOfDeletesOrUpdatesOnPrimary, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) {
        String action = "internal:index/shard/recovery/translog_ops";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryTranslogOperationsRequest request = new RecoveryTranslogOperationsRequest(this.recoveryId, requestSeqNo, this.shardId, operations, totalTranslogOps, maxSeenAutoIdTimestampOnPrimary, maxSeqNoOfDeletesOrUpdatesOnPrimary, retentionLeases, mappingVersionOnPrimary);
        Writeable.Reader<RecoveryTranslogOperationsResponse> reader = RecoveryTranslogOperationsResponse::new;
        this.executeRetryableAction("internal:index/shard/recovery/translog_ops", request, this.translogOpsRequestOptions, listener.map(r -> r.localCheckpoint), reader);
    }

    @Override
    public void receiveFileInfo(List<String> phase1FileNames, List<Long> phase1FileSizes, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, int totalTranslogOps, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/filesInfo";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFilesInfoRequest request = new RecoveryFilesInfoRequest(this.recoveryId, requestSeqNo, this.shardId, phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, totalTranslogOps);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        this.executeRetryableAction("internal:index/shard/recovery/filesInfo", request, this.standardTimeoutRequestOptions, listener.map(r -> null), reader);
    }

    @Override
    public void cleanFiles(int totalTranslogOps, long globalCheckpoint, Store.MetadataSnapshot sourceMetadata, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/clean_files";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryCleanFilesRequest request = new RecoveryCleanFilesRequest(this.recoveryId, requestSeqNo, this.shardId, sourceMetadata, totalTranslogOps, globalCheckpoint);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = listener.map(r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/clean_files", request, TransportRequestOptions.EMPTY, responseListener, reader);
    }

    @Override
    public void restoreFileFromSnapshot(String repository, IndexId indexId, BlobStoreIndexShardSnapshot.FileInfo snapshotFile, ActionListener<Void> listener) {
        String action = "internal:index/shard/recovery/restore_file_from_snapshot";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoverySnapshotFileRequest request = new RecoverySnapshotFileRequest(this.recoveryId, requestSeqNo, this.shardId, repository, indexId, snapshotFile);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        ActionListener responseListener = listener.map(r -> null);
        this.executeRetryableAction("internal:index/shard/recovery/restore_file_from_snapshot", request, TransportRequestOptions.EMPTY, responseListener, reader);
    }

    @Override
    public void writeFileChunk(StoreFileMetadata fileMetadata, long position, ReleasableBytesReference content, boolean lastChunk, int totalTranslogOps, ActionListener<Void> listener) {
        long throttleTimeInNanos;
        RateLimiter rl = this.recoverySettings.rateLimiter();
        if (rl != null) {
            long bytes = this.bytesSinceLastPause.addAndGet(content.length());
            if (bytes > rl.getMinPauseCheckBytes()) {
                this.bytesSinceLastPause.addAndGet(-bytes);
                try {
                    throttleTimeInNanos = rl.pause(bytes);
                    this.onSourceThrottle.accept(throttleTimeInNanos);
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to pause recovery", (Throwable)e, new Object[0]);
                }
            } else {
                throttleTimeInNanos = 0L;
            }
        } else {
            throttleTimeInNanos = 0L;
        }
        String action = "internal:index/shard/recovery/file_chunk";
        long requestSeqNo = this.requestSeqNoGenerator.getAndIncrement();
        RecoveryFileChunkRequest request = new RecoveryFileChunkRequest(this.recoveryId, requestSeqNo, this.shardId, fileMetadata, position, content, lastChunk, totalTranslogOps, throttleTimeInNanos);
        Writeable.Reader<TransportResponse.Empty> reader = in -> TransportResponse.Empty.INSTANCE;
        this.threadPool.generic().execute(ActionRunnable.wrap(listener, l -> this.executeRetryableAction("internal:index/shard/recovery/file_chunk", request, this.fileChunkRequestOptions, ActionListener.runBefore(l.map(r -> null), request::decRef), reader)));
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        if (this.onGoingRetryableActions.isEmpty()) {
            return;
        }
        CancellableThreads.ExecutionCancelledException exception = new CancellableThreads.ExecutionCancelledException("recovery was cancelled");
        this.threadPool.generic().execute(() -> {
            for (RetryableAction<?> action : this.onGoingRetryableActions.values()) {
                action.cancel(exception);
            }
            this.onGoingRetryableActions.clear();
        });
    }

    private <T extends TransportResponse> void executeRetryableAction(final String action, final RecoveryTransportRequest request, final TransportRequestOptions options, ActionListener<T> actionListener, final Writeable.Reader<T> reader) {
        Object key = new Object();
        ActionListener<T> removeListener = ActionListener.runBefore(actionListener, () -> this.onGoingRetryableActions.remove(key));
        TimeValue initialDelay = TimeValue.timeValueMillis((long)200L);
        TimeValue timeout = this.recoverySettings.internalActionRetryTimeout();
        RetryableAction retryableAction = new RetryableAction<T>(logger, this.threadPool, initialDelay, timeout, removeListener){

            @Override
            public void tryAction(ActionListener<T> listener) {
                if (request.tryIncRef()) {
                    RemoteRecoveryTargetHandler.this.transportService.sendRequest(RemoteRecoveryTargetHandler.this.targetNode, action, (TransportRequest)request, options, new ActionListenerResponseHandler(ActionListener.runBefore(listener, request::decRef), reader, "generic"));
                } else {
                    listener.onFailure((Exception)((Object)new AlreadyClosedException("already closed")));
                }
            }

            @Override
            public boolean shouldRetry(Exception e) {
                return RemoteRecoveryTargetHandler.this.retriesSupported && RemoteRecoveryTargetHandler.retryableException(e);
            }
        };
        this.onGoingRetryableActions.put(key, retryableAction);
        retryableAction.run();
        if (this.isCancelled) {
            retryableAction.cancel(new CancellableThreads.ExecutionCancelledException("recovery was cancelled"));
        }
    }

    private static boolean retryableException(Exception e) {
        if (e instanceof ConnectTransportException) {
            return true;
        }
        if (e instanceof SendRequestTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            return cause instanceof ConnectTransportException;
        }
        if (e instanceof RemoteTransportException) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            return cause instanceof CircuitBreakingException || cause instanceof EsRejectedExecutionException;
        }
        return false;
    }
}

