/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.fetch.subphase.FieldFetcher;
import org.elasticsearch.search.lookup.SourceLookup;

public class NestedValueFetcher
implements ValueFetcher {
    private final String nestedFieldPath;
    private final FieldFetcher nestedFieldFetcher;
    private final String nestedFieldName;
    private final String[] nestedPathParts;

    public NestedValueFetcher(String nestedField, FieldFetcher nestedFieldFetcher) {
        assert (nestedField != null && !nestedField.isEmpty());
        this.nestedFieldPath = nestedField;
        this.nestedFieldFetcher = nestedFieldFetcher;
        this.nestedPathParts = this.nestedFieldPath.split("\\.");
        this.nestedFieldName = this.nestedPathParts[this.nestedPathParts.length - 1];
    }

    @Override
    public List<Object> fetchValues(SourceLookup lookup) throws IOException {
        ArrayList<Object> nestedEntriesToReturn = new ArrayList<Object>();
        HashMap<String, Object> filteredSource = new HashMap<String, Object>();
        Map<String, Object> stub = this.createSourceMapStub(filteredSource);
        List<Map<?, ?>> nestedValues = XContentMapValues.extractNestedSources(this.nestedFieldPath, lookup.source());
        if (nestedValues == null) {
            return Collections.emptyList();
        }
        for (Map<?, ?> entry : nestedValues) {
            stub.put(this.nestedFieldName, entry);
            SourceLookup nestedSourceLookup = new SourceLookup();
            nestedSourceLookup.setSource(filteredSource);
            Map<String, DocumentField> fetchResult = this.nestedFieldFetcher.fetch(nestedSourceLookup);
            HashMap<String, List<Object>> nestedEntry = new HashMap<String, List<Object>>();
            for (DocumentField field : fetchResult.values()) {
                List<Object> fetchValues = field.getValues();
                if (fetchValues.isEmpty()) continue;
                String keyInNestedMap = field.getName().substring(this.nestedFieldPath.length() + 1);
                nestedEntry.put(keyInNestedMap, fetchValues);
            }
            if (nestedEntry.isEmpty()) continue;
            nestedEntriesToReturn.add(nestedEntry);
        }
        return nestedEntriesToReturn;
    }

    private Map<String, Object> createSourceMapStub(Map<String, Object> filteredSource) {
        Map<String, Object> next = filteredSource;
        for (int i = 0; i < this.nestedPathParts.length - 1; ++i) {
            String part = this.nestedPathParts[i];
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            next.put(part, newMap);
            next = newMap;
        }
        return next;
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        this.nestedFieldFetcher.setNextReader(context);
    }
}

