/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Types;
import org.elasticsearch.index.query.CoordinatorRewriteContext;
import org.elasticsearch.index.query.CoordinatorRewriteContextProvider;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.MinAndMax;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.transport.Transport;

final class CanMatchPreFilterSearchPhase
extends AbstractSearchAsyncAction<SearchService.CanMatchResponse> {
    private final Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory;
    private final GroupShardsIterator<SearchShardIterator> shardsIts;
    private final CoordinatorRewriteContextProvider coordinatorRewriteContextProvider;

    CanMatchPreFilterSearchPhase(Logger logger, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, Function<GroupShardsIterator<SearchShardIterator>, SearchPhase> phaseFactory, SearchResponse.Clusters clusters, CoordinatorRewriteContextProvider coordinatorRewriteContextProvider) {
        super("can_match", logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, executor, request, listener, shardsIts, timeProvider, clusterState, task, new CanMatchSearchPhaseResults(shardsIts.size()), shardsIts.size(), clusters);
        this.phaseFactory = phaseFactory;
        this.shardsIts = shardsIts;
        this.coordinatorRewriteContextProvider = coordinatorRewriteContextProvider;
    }

    @Override
    public void addReleasable(Releasable releasable) {
        throw new RuntimeException("cannot add releasable in " + this.getName() + " phase");
    }

    @Override
    protected void executePhaseOnShard(SearchShardIterator shardIt, SearchShardTarget shard, SearchActionListener<SearchService.CanMatchResponse> listener) {
        this.getSearchTransport().sendCanMatch(this.getConnection(shard.getClusterAlias(), shard.getNodeId()), this.buildShardSearchRequest(shardIt, listener.requestIndex), this.getTask(), listener);
    }

    @Override
    protected SearchPhase getNextPhase(SearchPhaseResults<SearchService.CanMatchResponse> results, SearchPhaseContext context) {
        return this.phaseFactory.apply(this.getIterator((CanMatchSearchPhaseResults)results, this.shardsIts));
    }

    private GroupShardsIterator<SearchShardIterator> getIterator(CanMatchSearchPhaseResults results, GroupShardsIterator<SearchShardIterator> shardsIts) {
        int i;
        int cardinality = results.getNumPossibleMatches();
        FixedBitSet possibleMatches = results.getPossibleMatches();
        if (cardinality == 0) {
            int shardIndexToQuery = 0;
            for (i = 0; i < shardsIts.size(); ++i) {
                if (shardsIts.get(i).size() <= 0) continue;
                shardIndexToQuery = i;
                break;
            }
            possibleMatches.set(shardIndexToQuery);
        }
        SearchSourceBuilder source = this.getRequest().source();
        i = 0;
        for (SearchShardIterator iter : shardsIts) {
            if (possibleMatches.get(i++)) {
                iter.reset();
                continue;
            }
            iter.resetAndSkip();
        }
        if (!CanMatchPreFilterSearchPhase.shouldSortShards(results.minAndMaxes)) {
            return shardsIts;
        }
        FieldSortBuilder fieldSort = FieldSortBuilder.getPrimaryFieldSortOrNull(source);
        return new GroupShardsIterator<SearchShardIterator>(CanMatchPreFilterSearchPhase.sortShards(shardsIts, results.minAndMaxes, fieldSort.order()));
    }

    @Override
    protected void performPhaseOnShard(int shardIndex, SearchShardIterator shardIt, SearchShardTarget shard) {
        CoordinatorRewriteContext coordinatorRewriteContext = this.coordinatorRewriteContextProvider.getCoordinatorRewriteContext(shardIt.shardId().getIndex());
        if (coordinatorRewriteContext == null) {
            super.performPhaseOnShard(shardIndex, shardIt, shard);
            return;
        }
        try {
            ShardSearchRequest request = this.buildShardSearchRequest(shardIt, shardIndex);
            boolean canMatch = SearchService.queryStillMatchesAfterRewrite(request, coordinatorRewriteContext);
            if (canMatch) {
                super.performPhaseOnShard(shardIndex, shardIt, shard);
                return;
            }
            SearchService.CanMatchResponse result = new SearchService.CanMatchResponse(canMatch, null);
            result.setSearchShardTarget(shard == null ? new SearchShardTarget(null, shardIt.shardId(), shardIt.getClusterAlias(), shardIt.getOriginalIndices()) : shard);
            result.setShardIndex(shardIndex);
            this.fork(() -> this.onShardResult(result, shardIt));
        }
        catch (Exception e) {
            super.performPhaseOnShard(shardIndex, shardIt, shard);
        }
    }

    private static List<SearchShardIterator> sortShards(GroupShardsIterator<SearchShardIterator> shardsIts, MinAndMax<?>[] minAndMaxes, SortOrder order) {
        return IntStream.range(0, shardsIts.size()).boxed().sorted(CanMatchPreFilterSearchPhase.shardComparator(shardsIts, minAndMaxes, order)).map(shardsIts::get).collect(Collectors.toList());
    }

    private static boolean shouldSortShards(MinAndMax<?>[] minAndMaxes) {
        Class<?> clazz = null;
        for (MinAndMax<?> minAndMax : minAndMaxes) {
            if (clazz == null) {
                clazz = minAndMax == null ? null : minAndMax.getMin().getClass();
                continue;
            }
            if (minAndMax == null || clazz == minAndMax.getMin().getClass()) continue;
            return false;
        }
        return clazz != null;
    }

    private static Comparator<Integer> shardComparator(GroupShardsIterator<SearchShardIterator> shardsIts, MinAndMax<?>[] minAndMaxes, SortOrder order) {
        Comparator<Integer> comparator = Comparator.comparing(index -> minAndMaxes[index], (Comparator)Types.forciblyCast(MinAndMax.getComparator(order)));
        return comparator.thenComparing(index -> (SearchShardIterator)shardsIts.get((int)index));
    }

    private static final class CanMatchSearchPhaseResults
    extends SearchPhaseResults<SearchService.CanMatchResponse> {
        private final FixedBitSet possibleMatches;
        private final MinAndMax<?>[] minAndMaxes;
        private int numPossibleMatches;

        CanMatchSearchPhaseResults(int size) {
            super(size);
            this.possibleMatches = new FixedBitSet(size);
            this.minAndMaxes = new MinAndMax[size];
        }

        @Override
        void consumeResult(SearchService.CanMatchResponse result, Runnable next) {
            try {
                this.consumeResult(result.getShardIndex(), result.canMatch(), result.estimatedMinAndMax());
            }
            finally {
                next.run();
            }
        }

        @Override
        boolean hasResult(int shardIndex) {
            return false;
        }

        @Override
        void consumeShardFailure(int shardIndex) {
            this.consumeResult(shardIndex, true, null);
        }

        synchronized void consumeResult(int shardIndex, boolean canMatch, MinAndMax<?> minAndMax) {
            if (canMatch) {
                this.possibleMatches.set(shardIndex);
                ++this.numPossibleMatches;
            }
            this.minAndMaxes[shardIndex] = minAndMax;
        }

        synchronized int getNumPossibleMatches() {
            return this.numPossibleMatches;
        }

        synchronized FixedBitSet getPossibleMatches() {
            return this.possibleMatches;
        }

        @Override
        Stream<SearchService.CanMatchResponse> getSuccessfulResults() {
            return Stream.empty();
        }
    }
}

