/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.web;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;

public class CORSResponseFilter
implements Filter {
    static final String ALLOWED_HOSTS = "allowedHosts";
    private List<String> allowedRemoteHosts = new ArrayList<String>();
    private boolean isUsingDb = false;
    private boolean addHeaderForAllHosts = false;

    public void init(FilterConfig config) {
        String allowedHosts = config.getInitParameter(ALLOWED_HOSTS);
        if (allowedHosts != null) {
            if (allowedHosts.equals("db")) {
                this.isUsingDb = true;
            } else if (allowedHosts.equals("*")) {
                this.addHeaderForAllHosts = true;
            } else if (!allowedHosts.equals("")) {
                this.allowedRemoteHosts = Arrays.asList(allowedHosts.split(","));
            }
        }
        if (Log.isDebugEnabled((String)"geonetwork.cors")) {
            Log.debug((String)"geonetwork.cors", (Object)String.format("CORS filter initialized. Using db setting '%s': %s. Add header for all: %s. Allowed hosts: %s.", "system/cors/allowedHosts", this.isUsingDb, this.addHeaderForAllHosts, this.allowedRemoteHosts));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String clientOriginUrl;
        String allowedHosts;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        SettingManager settingManager = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        if (this.isUsingDb && (allowedHosts = settingManager.getValue("system/cors/allowedHosts")) != null) {
            if (allowedHosts.equals("*")) {
                this.addHeaderForAllHosts = true;
            } else if (!allowedHosts.equals("")) {
                this.addHeaderForAllHosts = false;
                this.allowedRemoteHosts = Arrays.asList(allowedHosts.split(","));
            }
        }
        if ((this.addHeaderForAllHosts || this.allowedRemoteHosts.size() > 0) && (clientOriginUrl = httpRequest.getHeader("origin")) != null) {
            try {
                String clientOriginHost = new URI(clientOriginUrl).getHost();
                String myHost = settingManager.getValue("system/server/host");
                if (this.addHeaderForAllHosts || this.allowedRemoteHosts.indexOf(clientOriginHost) != -1 || clientOriginHost.equals(myHost)) {
                    httpResponse.setHeader("Access-Control-Allow-Origin", "*");
                    httpResponse.setHeader("Access-Control-Allow-Headers", "X-Requested-With, Content-Type");
                    httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
                    httpResponse.setHeader("Vary", "Origin");
                }
            }
            catch (Exception e) {
                Log.warning((String)"geonetwork.cors", (Object)String.format("An error occurs (%s) while getting the host of the origin header (ie. '%s') of the incoming request. CORS header not added.", e.getMessage(), clientOriginUrl));
            }
        }
        chain.doFilter(request, (ServletResponse)httpResponse);
    }

    public synchronized void destroy() {
    }
}

