/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security;

import java.util.Map;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.security.SecurityProviderUtil;

public interface SecurityProviderConfiguration {
    public String getLoginType();

    public String getSecurityProvider();

    public static SecurityProviderConfiguration get() {
        Map securityProviderConfigurations = ApplicationContextHolder.get().getBeansOfType(SecurityProviderConfiguration.class);
        if (securityProviderConfigurations != null && securityProviderConfigurations.size() != 0) {
            if (securityProviderConfigurations.size() != 1) {
                throw new RuntimeException("Too many security providers");
            }
            return (SecurityProviderConfiguration)securityProviderConfigurations.get(securityProviderConfigurations.keySet().toArray()[0]);
        }
        return null;
    }

    public boolean isUserProfileUpdateEnabled();

    public boolean isUserGroupUpdateEnabled();

    public static SecurityProviderUtil getSecurityProviderUtil() {
        Map SecurityProviderUtils = ApplicationContextHolder.get().getBeansOfType(SecurityProviderUtil.class);
        if (SecurityProviderUtils != null && SecurityProviderUtils.size() != 0) {
            if (SecurityProviderUtils.size() != 1) {
                throw new RuntimeException("Too many security providers utils");
            }
            return (SecurityProviderUtil)SecurityProviderUtils.get(SecurityProviderUtils.keySet().toArray()[0]);
        }
        return null;
    }

    public static enum LoginType {
        DEFAULT,
        FORM,
        LINK,
        AUTOLOGIN;


        public static LoginType parse(String type) throws BadInputEx {
            if (type == null || type.equalsIgnoreCase("default")) {
                return DEFAULT;
            }
            if (type.equalsIgnoreCase("form")) {
                return FORM;
            }
            if (type.equalsIgnoreCase("link")) {
                return LINK;
            }
            if (type.equalsIgnoreCase("autologin")) {
                return AUTOLOGIN;
            }
            throw new BadParameterEx("LoginType", (Object)type);
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

