/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Util;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusFinder;
import org.fao.geonet.kernel.search.keyword.KeywordRelation;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParams;
import org.fao.geonet.kernel.search.keyword.KeywordSearchParamsBuilder;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.jdom.Content;
import org.jdom.Element;

public class KeywordsSearcher {
    private final ThesaurusFinder _thesaurusFinder;
    private final IsoLanguagesMapper _isoLanguageMapper;
    private List<KeywordBean> _results = new ArrayList<KeywordBean>();

    public KeywordsSearcher(IsoLanguagesMapper mapper, ThesaurusFinder thesaurusFinder) {
        this._thesaurusFinder = thesaurusFinder;
        this._isoLanguageMapper = mapper;
    }

    public KeywordsSearcher(ServiceContext context, ThesaurusFinder thesaurusFinder) {
        this(context.getBean(IsoLanguagesMapper.class), thesaurusFinder);
    }

    public static Element toRawElement(Element rootEl, KeywordBean kb) {
        Element elKeyword = new Element("keyword");
        Element elSelected = new Element("selected");
        if (kb.isSelected()) {
            elSelected.addContent("true");
        } else {
            elSelected.addContent("false");
        }
        String defaultLang = kb.getDefaultLang();
        elKeyword.addContent((Content)elSelected);
        elKeyword.addContent((Content)new Element("id").addContent(Integer.toString(kb.getId())));
        elKeyword.addContent((Content)new Element("value").addContent(kb.getDefaultValue()).setAttribute("language", defaultLang));
        elKeyword.addContent((Content)new Element("definition").addContent(kb.getDefaultDefinition()).setAttribute("language", defaultLang));
        elKeyword.addContent((Content)new Element("defaultLang").addContent(defaultLang));
        Element thesaurusElement = new Element("thesaurus");
        thesaurusElement.addContent((Content)new Element("key").setText(kb.getThesaurusKey()));
        thesaurusElement.addContent((Content)new Element("title").setText(kb.getThesaurusTitle()));
        thesaurusElement.addContent((Content)new Element("date").setText(kb.getThesaurusDate()));
        thesaurusElement.addContent((Content)new Element("type").setText(kb.getType()));
        thesaurusElement.addContent((Content)new Element("url").setText(kb.getDownloadUrl()));
        elKeyword.addContent((Content)thesaurusElement);
        elKeyword.addContent((Content)new Element("uri").addContent(kb.getUriCode()));
        KeywordsSearcher.addBbox(kb, elKeyword);
        rootEl.addContent((Content)elKeyword);
        elKeyword.addContent((Content)KeywordsSearcher.addAllTranslations(kb, kb.getValues(), "values", "value"));
        elKeyword.addContent((Content)KeywordsSearcher.addAllTranslations(kb, kb.getDefinitions(), "definitions", "definition"));
        return rootEl;
    }

    private static Element addAllTranslations(KeywordBean kb, Map<String, String> map, String rootElemName, String leafElemName) {
        Element values = new Element(rootElemName);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            values.addContent((Content)new Element(leafElemName).addContent(entry.getValue()).setAttribute("language", entry.getKey()));
        }
        return values;
    }

    private static void addBbox(KeywordBean kb, Element elKeyword) {
        if (!(kb.getCoordEast() == null || kb.getCoordWest() == null || kb.getCoordSouth() == null || kb.getCoordNorth() == null || kb.getCoordEast().equals("") || kb.getCoordWest().equals("") || kb.getCoordSouth().equals("") || kb.getCoordNorth().equals(""))) {
            Element elBbox = new Element("geo");
            Element elEast = new Element("east");
            elEast.addContent(kb.getCoordEast());
            Element elWest = new Element("west");
            elWest.addContent(kb.getCoordWest());
            Element elSouth = new Element("south");
            elSouth.addContent(kb.getCoordSouth());
            Element elNorth = new Element("north");
            elNorth.addContent(kb.getCoordNorth());
            elBbox.addContent((Content)elEast);
            elBbox.addContent((Content)elWest);
            elBbox.addContent((Content)elSouth);
            elBbox.addContent((Content)elNorth);
            elKeyword.addContent((Content)elBbox);
        }
    }

    public KeywordBean searchById(String id, String sThesaurusName, String ... languages) {
        KeywordBean result = null;
        Thesaurus thesaurus = this._thesaurusFinder.getThesaurusByName(sThesaurusName);
        try {
            result = thesaurus.getKeyword(id, languages);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void searchTopConcepts(String sThesaurusName, String ... languages) throws Exception {
        this._results.clear();
        Thesaurus thesaurus = this._thesaurusFinder.getThesaurusByName(sThesaurusName);
        for (KeywordBean keywordBean : thesaurus.getTopConcepts(languages)) {
            this._results.add(keywordBean);
        }
    }

    public void search(KeywordSearchParams params) throws Exception {
        this._results = params.search(this._thesaurusFinder);
    }

    public void search(String contextLanguage, Element params) throws Exception {
        this.search(contextLanguage, params, null);
    }

    public void search(String contextLanguage, Element params, Comparator<KeywordBean> comparator) throws Exception {
        KeywordSearchParamsBuilder paramsBuilder;
        if (contextLanguage == null) {
            contextLanguage = "eng";
        }
        if ((paramsBuilder = KeywordSearchParamsBuilder.createFromElement(this._isoLanguageMapper, params)).getLangs().isEmpty()) {
            paramsBuilder.addLang(contextLanguage);
        }
        paramsBuilder.setComparator(comparator);
        this.search(paramsBuilder.build());
    }

    public void searchForRelated(Element params, KeywordRelation request, @Nullable Comparator<KeywordBean> comparator, String ... languages) {
        String id = Util.getParam((Element)params, (String)"id");
        String sThesaurusName = Util.getParam((Element)params, (String)"thesaurus");
        this.searchForRelated(id, sThesaurusName, request, comparator, languages);
    }

    public void searchForRelated(String id, String sThesaurusName, KeywordRelation request, @Nullable Comparator<KeywordBean> comparator, String ... languages) {
        this._results.clear();
        Thesaurus thesaurus = this._thesaurusFinder.getThesaurusByName(sThesaurusName);
        for (KeywordBean keywordBean : thesaurus.getRelated(id, request, languages)) {
            this._results.add(keywordBean);
        }
        if (comparator != null) {
            Collections.sort(this._results, comparator);
        }
    }

    public int getNbResults() {
        return this._results.size();
    }

    public List<KeywordBean> getResults() {
        return this._results;
    }

    public Element getXmlResults() throws Exception {
        Element elDescKeys = new Element("descKeys");
        int nbResults = this.getNbResults();
        for (int i = 0; i <= nbResults - 1; ++i) {
            KeywordBean kb = this._results.get(i);
            KeywordsSearcher.toRawElement(elDescKeys, kb);
        }
        return elDescKeys;
    }

    public void selectUnselectKeywords(Element params) {
        List listIdKeywordsSelected = params.getChildren("pIdKeyword");
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (Element el : listIdKeywordsSelected) {
            ids.add(el.getTextTrim());
        }
        this.selectUnselectKeywords(ids);
    }

    public void selectUnselectKeywords(Set<String> idSet) {
        for (KeywordBean keyword : this._results) {
            if (!idSet.contains("" + keyword.getId()) && !idSet.contains(keyword.getUriCode())) continue;
            keyword.setSelected(!keyword.isSelected());
        }
    }

    public void clearSelection() {
        for (KeywordBean keyword : this._results) {
            keyword.setSelected(false);
        }
    }

    public Element getSelectedKeywordsAsXml() {
        Element elDescKeys = new Element("descKeys");
        int nbSelectedKeywords = 0;
        for (int i = 0; i < this.getNbResults(); ++i) {
            KeywordBean kb = this._results.get(i);
            if (!kb.isSelected()) continue;
            KeywordsSearcher.toRawElement(elDescKeys, kb);
            ++nbSelectedKeywords;
        }
        Element elNbTot = new Element("nbtot");
        elNbTot.addContent(Integer.toString(nbSelectedKeywords));
        elDescKeys.addContent((Content)elNbTot);
        return elDescKeys;
    }

    public List<KeywordBean> getSelectedKeywordsInList() {
        ArrayList<KeywordBean> keywords = new ArrayList<KeywordBean>();
        for (int i = 0; i < this.getNbResults(); ++i) {
            KeywordBean kb = this._results.get(i);
            if (!kb.isSelected()) continue;
            keywords.add(kb);
        }
        return keywords;
    }

    public KeywordBean getKeywordFromResultsById(int id) {
        for (KeywordBean kb : this._results) {
            if (kb.getId() != id) continue;
            return kb;
        }
        return null;
    }

    public KeywordBean getKeywordFromResultsById(String id) {
        return this.getKeywordFromResultsById(Integer.parseInt(id));
    }

    public KeywordBean getKeywordFromResultsByUriCode(String code) {
        for (KeywordBean kb : this._results) {
            if (!kb.getUriCode().equals(code)) continue;
            return kb;
        }
        return null;
    }
}

