/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.oaipmh.services;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.oaipmh.OaiPmhService;
import org.fao.geonet.utils.Xml;
import org.fao.oaipmh.requests.AbstractRequest;
import org.fao.oaipmh.requests.ListMetadataFormatsRequest;
import org.fao.oaipmh.responses.AbstractResponse;
import org.fao.oaipmh.responses.ListMetadataFormatsResponse;
import org.fao.oaipmh.responses.MetadataFormat;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class ListMetadataFormats
implements OaiPmhService {
    private static final String DEFAULT_PREFIXES_FILE = "WEB-INF/config-oai-prefixes.xml";

    @Override
    public String getVerb() {
        return "ListMetadataFormats";
    }

    @Override
    public AbstractResponse execute(AbstractRequest request, ServiceContext context) throws Exception {
        ListMetadataFormatsRequest req = (ListMetadataFormatsRequest)request;
        ListMetadataFormatsResponse res = new ListMetadataFormatsResponse();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SchemaManager sm = gc.getBean(SchemaManager.class);
        String uuid = req.getIdentifier();
        if (uuid != null) {
            String schema = context.getBean(IMetadataUtils.class).findOneByUuid(uuid).getDataInfo().getSchemaId();
            res.addFormat(this.getSchemaInfo(context, sm, schema));
        } else {
            for (String schema : sm.getSchemas()) {
                res.addFormat(this.getSchemaInfo(context, sm, schema));
            }
        }
        for (MetadataFormat mdf : this.getConvertFormats(context)) {
            res.addFormat(mdf);
        }
        return res;
    }

    private MetadataFormat getSchemaInfo(ServiceContext context, SchemaManager sm, String name) throws IOException, JDOMException {
        MetadataFormat mf = new MetadataFormat();
        mf.prefix = name;
        mf.schema = "";
        mf.namespace = Namespace.NO_NAMESPACE;
        Attribute schemaLoc = sm.getSchemaLocation(name, context);
        if (schemaLoc != null) {
            if (schemaLoc.getName().equals("noNamespaceSchemaLocation")) {
                mf.schema = schemaLoc.getValue();
            } else {
                String sLoc = schemaLoc.getValue();
                String[] toks = sLoc.split("\\s");
                if (toks.length > 1) {
                    mf.namespace = Namespace.getNamespace((String)toks[0]);
                    mf.schema = toks[1];
                }
            }
        }
        return mf;
    }

    private List<MetadataFormat> getConvertFormats(ServiceContext context) throws IOException, JDOMException {
        Element elem = Xml.loadFile((Path)context.getAppPath().resolve(DEFAULT_PREFIXES_FILE));
        List defaultSchemas = elem.getChildren();
        ArrayList<MetadataFormat> defMdfs = new ArrayList<MetadataFormat>();
        for (Element schema : defaultSchemas) {
            defMdfs.add(new MetadataFormat(schema.getAttributeValue("prefix"), schema.getAttributeValue("schemaLocation"), schema.getAttributeValue("nsUrl")));
        }
        return defMdfs;
    }
}

