/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.collect.Maps;
import java.util.Map;
import org.fao.geonet.kernel.AllThesaurus;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.rdf.Selectors;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.sesame.query.QueryResultsTable;

public class AllQueryResultsTable
extends QueryResultsTable {
    private static final long serialVersionUID = 1L;
    private transient Map<Thesaurus, QueryResultsTable> allResults = Maps.newHashMap();
    private int rowCount = 0;

    public AllQueryResultsTable(Map<Thesaurus, QueryResultsTable> allResults) {
        super(AllQueryResultsTable.columnCount(allResults));
        this.allResults = allResults;
        for (QueryResultsTable allResult : allResults.values()) {
            this.rowCount += allResult.getRowCount();
        }
    }

    private static int columnCount(Map<Thesaurus, QueryResultsTable> allResults) {
        if (allResults.isEmpty()) {
            return 0;
        }
        return AllQueryResultsTable.firstValue(allResults).getColumnCount();
    }

    private static QueryResultsTable firstValue(Map<Thesaurus, QueryResultsTable> allResults) {
        return allResults.values().iterator().next();
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String[] getColumnNames() {
        if (this.getColumnCount() == 0) {
            return new String[0];
        }
        return AllQueryResultsTable.firstValue(this.allResults).getColumnNames();
    }

    public String getColumnName(int column) {
        if (this.getColumnCount() == 0) {
            return null;
        }
        return AllQueryResultsTable.firstValue(this.allResults).getColumnName(column);
    }

    public Value getValue(int row, int column) {
        int current = 0;
        for (Map.Entry<Thesaurus, QueryResultsTable> entry : this.allResults.entrySet()) {
            QueryResultsTable allResult = entry.getValue();
            if (row - current < allResult.getRowCount()) {
                Value value = allResult.getValue(row - current, column);
                if (Selectors.ID.id.equals(this.getColumnName(column))) {
                    String id = value.toString();
                    return new LiteralImpl(AllThesaurus.buildKeywordUri(entry.getKey().getKey(), id));
                }
                return value;
            }
            current += allResult.getRowCount();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AllQueryResultsTable that = (AllQueryResultsTable)((Object)o);
        if (this.rowCount != that.rowCount) {
            return false;
        }
        return this.allResults.equals(that.allResults);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.allResults.hashCode();
        result = 31 * result + this.rowCount;
        return result;
    }
}

