/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.exceptions;

import java.util.Locale;
import org.fao.geonet.exceptions.ILocalizedException;
import org.fao.geonet.languages.LocaleMessages;

public abstract class LocalizedException
extends Exception
implements ILocalizedException {
    private Locale locale;
    private String messageKey;
    private Object[] messageKeyArgs;
    private String descriptionKey;
    private Object[] descriptionKeyArgs;

    public LocalizedException() {
    }

    public LocalizedException(String message) {
        super(message);
    }

    public LocalizedException(String message, Throwable cause) {
        super(message, cause);
    }

    public LocalizedException(Throwable cause) {
        super(cause);
    }

    public LocalizedException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
    }

    public LocalizedException withMessageKey(String messageKey) {
        return this.withMessageKey(messageKey, null);
    }

    public LocalizedException withMessageKey(String messageKey, Object[] messageKeyArgs) {
        this.messageKey = messageKey;
        this.messageKeyArgs = messageKeyArgs;
        return this;
    }

    public LocalizedException withDescriptionKey(String descriptionKey) {
        return this.withDescriptionKey(descriptionKey, null);
    }

    public LocalizedException withDescriptionKey(String descriptionKey, Object[] descriptionKeyArgs) {
        this.descriptionKey = descriptionKey;
        this.descriptionKeyArgs = descriptionKeyArgs;
        return this;
    }

    public LocalizedException withLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    protected abstract String getResourceBundleBeanQualifier();

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String getLocalizedMessage() {
        return LocaleMessages.getMessageForLocale(this.messageKey, this.messageKeyArgs, this.locale, this.getResourceBundleBeanQualifier());
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    @Override
    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    @Override
    public Object[] getMessageKeyArgs() {
        return this.messageKeyArgs;
    }

    @Override
    public void setMessageKeyArgs(Object[] messageKeyArgs) {
        this.messageKeyArgs = messageKeyArgs;
    }

    @Override
    public String getLocalizedDescription() {
        return LocaleMessages.getMessageForLocale(this.descriptionKey, this.descriptionKeyArgs, this.locale, this.getResourceBundleBeanQualifier());
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Override
    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    @Override
    public Object[] getDescriptionKeyArgs() {
        return this.descriptionKeyArgs;
    }

    @Override
    public void setDescriptionKeyArgs(Object[] descriptionKeyArgs) {
        this.descriptionKeyArgs = descriptionKeyArgs;
    }
}

