/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import javax.resource.NotSupportedException;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.AbstractStore;
import org.fao.geonet.api.records.attachments.FilesystemStoreResource;
import org.fao.geonet.api.records.attachments.FilesystemStoreResourceContainer;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceContainer;
import org.fao.geonet.domain.MetadataResourceExternalManagementProperties;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.resources.JCloudConfiguration;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.springframework.beans.factory.annotation.Autowired;

public class JCloudStore
extends AbstractStore {
    private Path baseMetadataDir = null;
    @Autowired
    JCloudConfiguration jCloudConfiguration;
    @Autowired
    SettingManager settingManager;

    @Override
    public List<MetadataResource> getResources(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filter, Boolean approved) throws Exception {
        PageSet page;
        int metadataId = this.canDownload(context, metadataUuid, visibility, approved);
        String resourceTypeDir = this.getMetadataDir(context, metadataId) + this.jCloudConfiguration.getFolderDelimiter() + visibility.toString() + this.jCloudConfiguration.getFolderDelimiter();
        ArrayList<MetadataResource> resourceList = new ArrayList<MetadataResource>();
        if (filter == null) {
            filter = "*.*";
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + filter);
        ListContainerOptions opts = new ListContainerOptions();
        opts.delimiter(this.jCloudConfiguration.getFolderDelimiter()).prefix(resourceTypeDir);
        String marker = null;
        do {
            if (marker != null) {
                opts.afterMarker(marker);
            }
            page = this.jCloudConfiguration.getClient().getBlobStore().list(this.jCloudConfiguration.getContainerName(), opts);
            for (StorageMetadata storageMetadata : page) {
                Path keyPath = new File(storageMetadata.getName()).toPath().getFileName();
                if (storageMetadata.getType() != StorageType.BLOB || !matcher.matches(keyPath)) continue;
                String filename = JCloudStore.getFilename(storageMetadata.getName());
                MetadataResource resource = this.createResourceDescription(context, metadataUuid, visibility, filename, storageMetadata, metadataId, approved);
                resourceList.add(resource);
            }
        } while ((marker = page.getNextMarker()) != null);
        resourceList.sort(MetadataResourceVisibility.sortByFileName);
        return resourceList;
    }

    private MetadataResource createResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, StorageMetadata storageMetadata, int metadataId, boolean approved) {
        String filename = this.getFilename(metadataUuid, resourceId);
        String versionValue = null;
        if (this.jCloudConfiguration.isVersioningEnabled().booleanValue()) {
            versionValue = storageMetadata.getETag();
        }
        MetadataResourceExternalManagementProperties metadataResourceExternalManagementProperties = this.getMetadataResourceExternalManagementProperties(context, metadataId, metadataUuid, visibility, resourceId, filename, storageMetadata.getETag(), storageMetadata.getType());
        return new FilesystemStoreResource(metadataUuid, metadataId, filename, this.settingManager.getNodeURL() + "api/records/", visibility, storageMetadata.getSize(), storageMetadata.getLastModified(), versionValue, metadataResourceExternalManagementProperties, approved);
    }

    private static String getFilename(String key) {
        String[] splittedKey = key.split("/");
        return splittedKey[splittedKey.length - 1];
    }

    @Override
    public Store.ResourceHolder getResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canDownload(context, metadataUuid, visibility, approved);
        try {
            Blob object = this.jCloudConfiguration.getClient().getBlobStore().getBlob(this.jCloudConfiguration.getContainerName(), this.getKey(context, metadataUuid, metadataId, visibility, resourceId));
            return new ResourceHolderImpl(object, this.createResourceDescription(context, metadataUuid, visibility, resourceId, (StorageMetadata)object.getMetadata(), metadataId, approved));
        }
        catch (ContainerNotFoundException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Error getting metadata resource. '%s' not found for metadata '%s'", resourceId, metadataUuid));
            throw new ResourceNotFoundException(String.format("Error getting metadata resource. '%s' not found for metadata '%s'", resourceId, metadataUuid));
        }
    }

    @Override
    public Store.ResourceHolder getResourceInternal(String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        throw new NotSupportedException("JCloud does not support getResourceInternal.");
    }

    private String getKey(ServiceContext context, String metadataUuid, int metadataId, MetadataResourceVisibility visibility, String resourceId) {
        this.checkResourceId(resourceId);
        String metadataDir = this.getMetadataDir(context, metadataId);
        return metadataDir + this.jCloudConfiguration.getFolderDelimiter() + visibility.toString() + this.jCloudConfiguration.getFolderDelimiter() + this.getFilename(metadataUuid, resourceId);
    }

    @Override
    public MetadataResource putResource(ServiceContext context, String metadataUuid, String filename, InputStream is, @Nullable Date changeDate, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        String key = this.getKey(context, metadataUuid, metadataId, visibility, filename);
        Blob blob = this.jCloudConfiguration.getClient().getBlobStore().blobBuilder(key).payload(is).contentLength((long)is.available()).build();
        this.jCloudConfiguration.getClient().getBlobStore().putBlob(this.jCloudConfiguration.getContainerName(), blob, PutOptions.Builder.multipart());
        Blob blobResults = this.jCloudConfiguration.getClient().getBlobStore().getBlob(this.jCloudConfiguration.getContainerName(), key);
        return this.createResourceDescription(context, metadataUuid, visibility, filename, (StorageMetadata)blobResults.getMetadata(), metadataId, approved);
    }

    @Override
    public MetadataResource patchResourceStatus(ServiceContext context, String metadataUuid, String resourceId, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        String sourceKey = null;
        BlobMetadata storageMetadata = null;
        for (MetadataResourceVisibility sourceVisibility : MetadataResourceVisibility.values()) {
            String key = this.getKey(context, metadataUuid, metadataId, sourceVisibility, resourceId);
            try {
                storageMetadata = this.jCloudConfiguration.getClient().getBlobStore().blobMetadata(this.jCloudConfiguration.getContainerName(), key);
                if (storageMetadata == null) continue;
                if (sourceVisibility != visibility) {
                    sourceKey = key;
                    break;
                }
                return this.createResourceDescription(context, metadataUuid, visibility, resourceId, (StorageMetadata)storageMetadata, metadataId, approved);
            }
            catch (ContainerNotFoundException containerNotFoundException) {
                // empty catch block
            }
        }
        if (sourceKey != null) {
            String destKey = this.getKey(context, metadataUuid, metadataId, visibility, resourceId);
            this.jCloudConfiguration.getClient().getBlobStore().copyBlob(this.jCloudConfiguration.getContainerName(), sourceKey, this.jCloudConfiguration.getContainerName(), destKey, CopyOptions.NONE);
            this.jCloudConfiguration.getClient().getBlobStore().removeBlob(this.jCloudConfiguration.getContainerName(), sourceKey);
            Blob blobResults = this.jCloudConfiguration.getClient().getBlobStore().getBlob(this.jCloudConfiguration.getContainerName(), destKey);
            return this.createResourceDescription(context, metadataUuid, visibility, resourceId, (StorageMetadata)blobResults.getMetadata(), metadataId, approved);
        }
        Log.warning((String)"geonetwork.resources", (Object)String.format("Could not update permissions. Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid));
        throw new ResourceNotFoundException(String.format("Could not update permissions. Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid));
    }

    @Override
    public String delResources(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        try {
            PageSet page;
            ListContainerOptions opts = new ListContainerOptions();
            opts.prefix(this.getMetadataDir(context, metadataId) + this.jCloudConfiguration.getFolderDelimiter()).recursive();
            String marker = null;
            do {
                if (marker != null) {
                    opts.afterMarker(marker);
                }
                page = this.jCloudConfiguration.getClient().getBlobStore().list(this.jCloudConfiguration.getContainerName(), opts);
                for (StorageMetadata storageMetadata : page) {
                    if (storageMetadata.getType() != StorageType.BLOB) continue;
                    this.jCloudConfiguration.getClient().getBlobStore().removeBlob(this.jCloudConfiguration.getContainerName(), storageMetadata.getName());
                }
            } while ((marker = page.getNextMarker()) != null);
            return String.format("Metadata '%s' directory removed.", metadataId);
        }
        catch (ContainerNotFoundException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to located metadata '%s' directory to be removed.", metadataId));
            return String.format("Unable to located metadata '%s' directory to be removed.", metadataId);
        }
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        for (MetadataResourceVisibility visibility : MetadataResourceVisibility.values()) {
            if (!this.tryDelResource(context, metadataUuid, metadataId, visibility, resourceId)) continue;
            return String.format("MetadataResource '%s' removed.", resourceId);
        }
        return String.format("Unable to remove resource '%s'.", resourceId);
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        if (this.tryDelResource(context, metadataUuid, metadataId, visibility, resourceId)) {
            return String.format("MetadataResource '%s' removed.", resourceId);
        }
        return String.format("Unable to remove resource '%s'.", resourceId);
    }

    private boolean tryDelResource(ServiceContext context, String metadataUuid, int metadataId, MetadataResourceVisibility visibility, String resourceId) throws Exception {
        String key = this.getKey(context, metadataUuid, metadataId, visibility, resourceId);
        if (this.jCloudConfiguration.getClient().getBlobStore().blobExists(this.jCloudConfiguration.getContainerName(), key)) {
            this.jCloudConfiguration.getClient().getBlobStore().removeBlob(this.jCloudConfiguration.getContainerName(), key);
            return true;
        }
        return false;
    }

    @Override
    public MetadataResource getResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filename, Boolean approved) throws Exception {
        int metadataId = JCloudStore.getAndCheckMetadataId(metadataUuid, approved);
        String key = this.getKey(context, metadataUuid, metadataId, visibility, filename);
        try {
            Blob object = this.jCloudConfiguration.getClient().getBlobStore().getBlob(this.jCloudConfiguration.getContainerName(), key);
            if (object == null) {
                return null;
            }
            MutableBlobMetadata metadata = object.getMetadata();
            return this.createResourceDescription(context, metadataUuid, visibility, filename, (StorageMetadata)metadata, metadataId, approved);
        }
        catch (ContainerNotFoundException e) {
            return null;
        }
    }

    @Override
    public MetadataResourceContainer getResourceContainerDescription(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        int metadataId = JCloudStore.getAndCheckMetadataId(metadataUuid, approved);
        return new FilesystemStoreResourceContainer(metadataUuid, metadataId, metadataUuid, this.settingManager.getNodeURL() + "api/records/", approved);
    }

    private String getMetadataDir(ServiceContext context, int metadataId) {
        Path metadataFullDir = Lib.resource.getMetadataDir(this.getDataDirectory(context), metadataId);
        Path baseMetadataDir = this.getBaseMetadataDir(context, metadataFullDir);
        Path metadataDir = baseMetadataDir.toString().equals(".") ? Paths.get(this.jCloudConfiguration.getBaseFolder(), new String[0]).resolve(metadataFullDir) : Paths.get(this.jCloudConfiguration.getBaseFolder(), new String[0]).resolve(baseMetadataDir.relativize(metadataFullDir));
        String key = metadataDir.getFileSystem().getSeparator().equals(this.jCloudConfiguration.getFolderDelimiter()) ? metadataDir.toString() : metadataDir.toString().replace(metadataDir.getFileSystem().getSeparator(), this.jCloudConfiguration.getFolderDelimiter());
        if (key.startsWith("//")) {
            key = key.substring(1);
        }
        if (key.startsWith(this.jCloudConfiguration.getFolderDelimiter())) {
            return key.substring(1);
        }
        return key;
    }

    private Path getBaseMetadataDir(ServiceContext context, Path metadataFullDir) {
        if (this.baseMetadataDir == null) {
            Path systemFullDir = this.getDataDirectory(context).getSystemDataDir();
            this.baseMetadataDir = metadataFullDir.toString().startsWith(systemFullDir.toString()) ? systemFullDir : (this.getDataDirectory(context).getMetadataDataDir().isAbsolute() ? metadataFullDir.getRoot() : Paths.get(".", new String[0]));
        }
        return this.baseMetadataDir;
    }

    private GeonetworkDataDirectory getDataDirectory(ServiceContext context) {
        return context.getBean(GeonetworkDataDirectory.class);
    }

    private MetadataResourceExternalManagementProperties getMetadataResourceExternalManagementProperties(ServiceContext context, int metadataId, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, String filename, String version, StorageType type) {
        String metadataResourceExternalManagementPropertiesUrl = this.jCloudConfiguration.getExternalResourceManagementUrl();
        if (!StringUtils.isEmpty((String)metadataResourceExternalManagementPropertiesUrl)) {
            if (metadataResourceExternalManagementPropertiesUrl.contains("{id}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{id\\})", resourceId);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{type:")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("\\{type:([a-zA-Z0-9]*?):([a-zA-Z0-9]*?)\\}", type == null ? "" : (StorageType.FOLDER.equals((Object)type) ? "$1" : "$2"));
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{uuid}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{uuid\\})", metadataUuid == null ? "" : metadataUuid);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{metadataid}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{metadataid\\})", String.valueOf(metadataId));
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{visibility}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{visibility\\})", visibility == null ? "" : visibility.toString().toLowerCase());
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{filename}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{filename\\})", filename == null ? "" : filename);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{version}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{version\\})", version == null ? "" : version);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{lang}") || metadataResourceExternalManagementPropertiesUrl.contains("{ISO3lang}")) {
                String iso3Lang;
                String lang;
                String contextLang;
                IsoLanguagesMapper mapper = context.getBean(IsoLanguagesMapper.class);
                String string = contextLang = context.getLanguage() == null ? "eng" : context.getLanguage();
                if (contextLang.length() == 2) {
                    lang = contextLang;
                    iso3Lang = mapper.iso639_1_to_iso639_2(contextLang);
                } else {
                    lang = mapper.iso639_2_to_iso639_1(contextLang);
                    iso3Lang = contextLang;
                }
                if (metadataResourceExternalManagementPropertiesUrl.contains("{lang}")) {
                    metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{lang\\})", lang);
                }
                if (metadataResourceExternalManagementPropertiesUrl.contains("{iso3lang}")) {
                    metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{iso3lang\\})", iso3Lang);
                }
            }
        }
        MetadataResourceExternalManagementProperties metadataResourceExternalManagementProperties = new MetadataResourceExternalManagementProperties(resourceId, metadataResourceExternalManagementPropertiesUrl);
        return metadataResourceExternalManagementProperties;
    }

    @Override
    public Store.ResourceManagementExternalProperties getResourceManagementExternalProperties() {
        return new Store.ResourceManagementExternalProperties(){

            @Override
            public boolean isEnabled() {
                return !StringUtils.isEmpty((String)JCloudStore.this.jCloudConfiguration.getExternalResourceManagementUrl());
            }

            @Override
            public String getWindowParameters() {
                return JCloudStore.this.jCloudConfiguration.getExternalResourceManagementWindowParameters();
            }

            @Override
            public boolean isModal() {
                return JCloudStore.this.jCloudConfiguration.isExternalResourceManagementModalEnabled();
            }

            @Override
            public boolean isFolderEnabled() {
                return this.isEnabled() && JCloudStore.this.jCloudConfiguration.isExternalResourceManagementFolderEnabled() != false;
            }

            public String toString() {
                try {
                    return new ObjectMapper().writeValueAsString((Object)this);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error converting ResourceManagementExternalProperties to json", e);
                }
            }
        };
    }

    private static class ResourceHolderImpl
    implements Store.ResourceHolder {
        private Path tempFolderPath;
        private Path path;
        private final MetadataResource metadataResource;

        public ResourceHolderImpl(Blob object, MetadataResource metadataResource) throws IOException {
            this.tempFolderPath = Files.createTempDirectory("gn-meta-res-" + String.valueOf(metadataResource.getMetadataId() + "-"), new FileAttribute[0]);
            this.tempFolderPath.toFile().deleteOnExit();
            this.path = this.tempFolderPath.resolve(JCloudStore.getFilename(object.getMetadata().getName()));
            this.metadataResource = metadataResource;
            try (InputStream in = object.getPayload().openStream();){
                Files.copy(in, this.path, StandardCopyOption.REPLACE_EXISTING);
            }
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        @Override
        public MetadataResource getMetadata() {
            return this.metadataResource;
        }

        @Override
        public void close() throws IOException {
            IO.deleteFileOrDirectory((Path)this.tempFolderPath, (boolean)true);
            this.path = null;
            this.tempFolderPath = null;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

