/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.attachments;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.resource.NotSupportedException;
import jeeves.server.context.ServiceContext;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.commons.collections.MapUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.AbstractStore;
import org.fao.geonet.api.records.attachments.FilesystemStoreResource;
import org.fao.geonet.api.records.attachments.FilesystemStoreResourceContainer;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResource;
import org.fao.geonet.domain.MetadataResourceContainer;
import org.fao.geonet.domain.MetadataResourceExternalManagementProperties;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.resources.CMISConfiguration;
import org.fao.geonet.resources.CMISUtils;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class CMISStore
extends AbstractStore {
    private Path baseMetadataDir = null;
    @Autowired
    CMISConfiguration cmisConfiguration;
    @Autowired
    CMISUtils cmisUtils;
    @Autowired
    SettingManager settingManager;

    @Override
    public List<MetadataResource> getResources(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filter, Boolean approved) throws Exception {
        int metadataId = this.canDownload(context, metadataUuid, visibility, approved);
        String resourceTypeDir = this.getMetadataDir(context, metadataId) + this.cmisConfiguration.getFolderDelimiter() + visibility.toString();
        ArrayList<MetadataResource> resourceList = new ArrayList<MetadataResource>();
        if (filter == null) {
            filter = "*.*";
        }
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + filter);
        try {
            Folder parentFolder = (Folder)this.cmisConfiguration.getClient().getObjectByPath(resourceTypeDir);
            Map<String, Document> documentMap = this.cmisUtils.getCmisObjectMap(parentFolder, null);
            for (Map.Entry<String, Document> entry : documentMap.entrySet()) {
                Path keyPath;
                Document object = entry.getValue();
                String cmisFilePath = entry.getKey();
                if (!(object instanceof Document) || !matcher.matches(keyPath = new File(cmisFilePath).toPath().getFileName())) continue;
                String filename = CMISStore.getFilename(cmisFilePath);
                MetadataResource resource = this.createResourceDescription(context, metadataUuid, visibility, filename, object, metadataId, approved);
                resourceList.add(resource);
            }
        }
        catch (CmisObjectNotFoundException cmisObjectNotFoundException) {
            // empty catch block
        }
        resourceList.sort(MetadataResourceVisibility.sortByFileName);
        return resourceList;
    }

    private MetadataResource createResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Document document, int metadataId, boolean approved) {
        String filename = this.getFilename(metadataUuid, resourceId);
        String versionValue = null;
        if (this.cmisConfiguration.isVersioningEnabled().booleanValue()) {
            versionValue = document.getVersionLabel();
        }
        MetadataResourceExternalManagementProperties metadataResourceExternalManagementProperties = this.getMetadataResourceExternalManagementProperties(context, metadataId, metadataUuid, visibility, resourceId, filename, document.getVersionLabel(), document.getVersionSeriesId(), document.getType());
        return new FilesystemStoreResource(metadataUuid, metadataId, filename, this.settingManager.getNodeURL() + "api/records/", visibility, document.getContentStreamLength(), document.getLastModificationDate().getTime(), versionValue, metadataResourceExternalManagementProperties, approved);
    }

    private static String getFilename(String key) {
        String[] splittedKey = key.split("/");
        return splittedKey[splittedKey.length - 1];
    }

    @Override
    public Store.ResourceHolder getResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canDownload(context, metadataUuid, visibility, approved);
        try {
            CmisObject object = this.cmisConfiguration.getClient().getObjectByPath(this.getKey(context, metadataUuid, metadataId, visibility, resourceId));
            return new ResourceHolderImpl(object, this.createResourceDescription(context, metadataUuid, visibility, resourceId, (Document)object, metadataId, approved));
        }
        catch (CmisObjectNotFoundException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Error getting metadata resource. '%s' not found for metadata '%s'", resourceId, metadataUuid));
            throw new ResourceNotFoundException(String.format("Error getting metadata resource. '%s' not found for metadata '%s'", resourceId, metadataUuid));
        }
    }

    @Override
    public Store.ResourceHolder getResourceInternal(String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        throw new NotSupportedException("CMISStore does not support getResourceInternal.");
    }

    private String getKey(ServiceContext context, String metadataUuid, int metadataId, MetadataResourceVisibility visibility, String resourceId) {
        this.checkResourceId(resourceId);
        String metadataDir = this.getMetadataDir(context, metadataId);
        return metadataDir + this.cmisConfiguration.getFolderDelimiter() + visibility.toString() + this.cmisConfiguration.getFolderDelimiter() + this.getFilename(metadataUuid, resourceId);
    }

    @Override
    public MetadataResource putResource(ServiceContext context, String metadataUuid, String filename, InputStream is, @Nullable Date changeDate, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        return this.putResource(context, metadataUuid, filename, is, changeDate, visibility, approved, null);
    }

    private MetadataResource putResource(ServiceContext context, String metadataUuid, String filename, InputStream is, @Nullable Date changeDate, MetadataResourceVisibility visibility, Boolean approved, Map<String, Object> additionalProperties) throws Exception {
        CmisObject cmisObject;
        int metadataId = this.canEdit(context, metadataUuid, approved);
        String key = this.getKey(context, metadataUuid, metadataId, visibility, filename);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.setCmisMetadataUUIDPrimary(properties, metadataUuid);
        try {
            cmisObject = this.cmisConfiguration.getClient().getObjectByPath(key);
        }
        catch (Exception e) {
            cmisObject = null;
        }
        Document doc = this.cmisUtils.saveDocument(key, cmisObject, properties, is, changeDate);
        if (this.cmisConfiguration.existSecondaryProperty()) {
            HashMap<String, Object> secondaryProperties = new HashMap<String, Object>();
            if (MapUtils.isNotEmpty(additionalProperties)) {
                secondaryProperties.putAll(additionalProperties);
            }
            this.setCmisMetadataUUIDSecondary(doc, secondaryProperties, metadataUuid);
            try {
                doc.updateProperties(secondaryProperties);
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.resources", (Object)String.format("Unable to update CMIS secondary property on metadata resource '%s' for metadata '%s'.", key, metadataUuid), (Throwable)e);
            }
        }
        return this.createResourceDescription(context, metadataUuid, visibility, filename, doc, metadataId, approved);
    }

    private void setCmisMetadataUUIDPrimary(Map<String, Object> properties, String metadataUuid) {
        if (!StringUtils.isEmpty((Object)this.cmisConfiguration.getCmisMetadataUUIDPropertyName()) && !this.cmisConfiguration.getCmisMetadataUUIDPropertyName().contains(this.cmisConfiguration.getSecondaryPropertySeparator())) {
            properties.put(this.cmisConfiguration.getCmisMetadataUUIDPropertyName(), metadataUuid);
        }
    }

    private void setCmisMetadataUUIDSecondary(Document doc, Map<String, Object> properties, String metadataUuid) {
        if (!StringUtils.isEmpty((Object)this.cmisConfiguration.getCmisMetadataUUIDPropertyName()) && this.cmisConfiguration.getCmisMetadataUUIDPropertyName().contains(this.cmisConfiguration.getSecondaryPropertySeparator())) {
            String[] splitPropertyNames = this.cmisConfiguration.getCmisMetadataUUIDPropertyName().split(Pattern.quote(this.cmisConfiguration.getSecondaryPropertySeparator()));
            String aspectName = splitPropertyNames[0];
            String secondaryPropertyName = splitPropertyNames[1];
            ArrayList<String> aspects = null;
            Property secondaryProperty = doc.getProperty("cmis:secondaryObjectTypeIds");
            if (secondaryProperty != null) {
                aspects = new ArrayList<String>(secondaryProperty.getValues());
            }
            if (aspects == null) {
                aspects = new ArrayList();
            }
            if (!aspects.contains(aspectName)) {
                aspects.add(aspectName);
            }
            properties.put("cmis:secondaryObjectTypeIds", aspects);
            properties.put(secondaryPropertyName, metadataUuid);
        }
    }

    @Override
    public MetadataResource patchResourceStatus(ServiceContext context, String metadataUuid, String resourceId, MetadataResourceVisibility visibility, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        OperationContext oc = this.cmisUtils.createOperationContext();
        oc.setCacheEnabled(false);
        String sourceKey = null;
        CmisObject sourceObject = null;
        for (MetadataResourceVisibility sourceVisibility : MetadataResourceVisibility.values()) {
            String key = this.getKey(context, metadataUuid, metadataId, sourceVisibility, resourceId);
            try {
                CmisObject object = this.cmisConfiguration.getClient().getObjectByPath(key, oc);
                if (sourceVisibility == visibility) {
                    return this.createResourceDescription(context, metadataUuid, visibility, resourceId, (Document)object, metadataId, approved);
                }
                sourceKey = key;
                sourceObject = object;
                break;
            }
            catch (CmisObjectNotFoundException object) {
            }
        }
        if (sourceKey != null) {
            FileableCmisObject object;
            String destKey = this.getKey(context, metadataUuid, metadataId, visibility, resourceId);
            int lastFolderDelimiterSourceKeyIndex = sourceKey.lastIndexOf(this.cmisConfiguration.getFolderDelimiter());
            String parentSourceKey = sourceKey.substring(0, lastFolderDelimiterSourceKeyIndex);
            Folder parentSourceFolder = this.cmisUtils.getFolderCache(parentSourceKey);
            int lastFolderDelimiterDestKeyIndex = destKey.lastIndexOf(this.cmisConfiguration.getFolderDelimiter());
            String parentDestFolderKey = destKey.substring(0, lastFolderDelimiterDestKeyIndex);
            Folder parentDestFolder = this.cmisUtils.getFolderCache(parentDestFolderKey, true);
            try {
                object = ((Document)sourceObject).move((ObjectId)parentSourceFolder, (ObjectId)parentDestFolder, oc);
                Log.info((String)"geonetwork.resources", (Object)String.format("moved resource '%s' to '%s'.", parentSourceFolder.getPaths().get(0), parentDestFolder.getPaths().get(0)));
            }
            catch (CmisPermissionDeniedException e) {
                Log.warning((String)"geonetwork.resources", (Object)String.format("No permissions to modify metadata resource '%s' for metadata '%s'.", resourceId, metadataUuid));
                throw new NotAllowedException(String.format("No permissions to modify metadata resource '%s' for metadata '%s'.", resourceId, metadataUuid));
            }
            return this.createResourceDescription(context, metadataUuid, visibility, resourceId, (Document)object, metadataId, approved);
        }
        Log.warning((String)"geonetwork.resources", (Object)String.format("Could not update permissions. Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid));
        throw new ResourceNotFoundException(String.format("Could not update permissions. Metadata resource '%s' not found for metadata '%s'", resourceId, metadataUuid));
    }

    @Override
    public String delResources(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        OperationContext oc = this.cmisConfiguration.getClient().createOperationContext();
        oc.setCacheEnabled(false);
        int metadataId = this.canEdit(context, metadataUuid, approved);
        String folderKey = null;
        try {
            folderKey = this.getMetadataDir(context, metadataId);
            Folder folder = (Folder)this.cmisConfiguration.getClient().getObjectByPath(folderKey, oc);
            folder.deleteTree(true, UnfileObject.DELETE, true);
            this.cmisUtils.invalidateFolderCache(folderKey);
            Log.info((String)"geonetwork.resources", (Object)String.format("Metadata '%s(%s)' directory '%s' removed.", metadataUuid, metadataId, folderKey));
            return String.format("Metadata '%s(%s)' directory '%s' removed.", metadataUuid, metadataId, folderKey);
        }
        catch (CmisObjectNotFoundException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to located metadata '%s(%s)' directory '%s' to be removed.", metadataUuid, metadataId, folderKey));
            return String.format("Unable to located metadata '%s(%s)' directory '%s' to be removed.", metadataUuid, metadataId, folderKey);
        }
        catch (ResourceNotFoundException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to located metadata '%s(%s)' directory '%s' to be removed.", metadataUuid, metadataId, folderKey));
            return String.format("Unable to located metadata '%s(%s)' directory '%s' to be removed.", metadataUuid, metadataId, folderKey);
        }
        catch (CmisPermissionDeniedException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Insufficient privileges, unable to remove metadata '%s(%s)' directory '%s'.", metadataUuid, metadataId, folderKey));
            return String.format("Insufficient privileges, unable to remove metadata '%s(%s)' directory '%s'.", metadataUuid, metadataId, folderKey);
        }
        catch (CmisConstraintException e) {
            Log.warning((String)"geonetwork.resources", (Object)String.format("Unable to remove metadata '%s(%s)' directory '%s' due so constraint violation or locks.", metadataUuid, metadataId, folderKey));
            return String.format("Unable to remove metadata '%s(%s)' directory '%s' due so constraint violation or locks.", metadataUuid, metadataId, folderKey);
        }
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        for (MetadataResourceVisibility visibility : MetadataResourceVisibility.values()) {
            if (!this.tryDelResource(context, metadataUuid, metadataId, visibility, resourceId)) continue;
            Log.info((String)"geonetwork.resources", (Object)String.format("MetadataResource '%s' removed.", resourceId));
            return String.format("MetadataResource '%s' removed.", resourceId);
        }
        Log.info((String)"geonetwork.resources", (Object)String.format("Unable to remove resource '%s'.", resourceId));
        return String.format("Unable to remove resource '%s'.", resourceId);
    }

    @Override
    public String delResource(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, Boolean approved) throws Exception {
        int metadataId = this.canEdit(context, metadataUuid, approved);
        if (this.tryDelResource(context, metadataUuid, metadataId, visibility, resourceId)) {
            Log.info((String)"geonetwork.resources", (Object)String.format("MetadataResource '%s' removed.", resourceId));
            return String.format("MetadataResource '%s' removed.", resourceId);
        }
        Log.info((String)"geonetwork.resources", (Object)String.format("Unable to remove resource '%s'.", resourceId));
        return String.format("Unable to remove resource '%s'.", resourceId);
    }

    private boolean tryDelResource(ServiceContext context, String metadataUuid, int metadataId, MetadataResourceVisibility visibility, String resourceId) throws Exception {
        String key = this.getKey(context, metadataUuid, metadataId, visibility, resourceId);
        OperationContext oc = this.cmisUtils.createOperationContext();
        oc.setCacheEnabled(false);
        try {
            CmisObject object = this.cmisConfiguration.getClient().getObjectByPath(key, oc);
            object.delete();
            if (object instanceof Folder) {
                this.cmisUtils.invalidateFolderCacheItem(key);
            }
            return true;
        }
        catch (CmisConstraintException | CmisObjectNotFoundException | CmisPermissionDeniedException e) {
            return false;
        }
    }

    @Override
    public MetadataResource getResourceDescription(ServiceContext context, String metadataUuid, MetadataResourceVisibility visibility, String filename, Boolean approved) throws Exception {
        int metadataId = CMISStore.getAndCheckMetadataId(metadataUuid, approved);
        String key = this.getKey(context, metadataUuid, metadataId, visibility, filename);
        try {
            CmisObject object = this.cmisConfiguration.getClient().getObjectByPath(key);
            return this.createResourceDescription(context, metadataUuid, visibility, filename, (Document)object, metadataId, approved);
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
    }

    @Override
    public MetadataResourceContainer getResourceContainerDescription(ServiceContext context, String metadataUuid, Boolean approved) throws Exception {
        int metadataId = CMISStore.getAndCheckMetadataId(metadataUuid, approved);
        String key = this.getMetadataDir(context, metadataId);
        try {
            String folderRoot = this.cmisConfiguration.getExternalResourceManagementFolderRoot();
            if (folderRoot == null) {
                folderRoot = "";
            }
            Folder parentFolder = this.cmisUtils.getFolderCache(key + folderRoot);
            MetadataResourceExternalManagementProperties metadataResourceExternalManagementProperties = this.getMetadataResourceExternalManagementProperties(context, metadataId, metadataUuid, null, String.valueOf(metadataId), null, null, parentFolder.getId(), parentFolder.getType());
            return new FilesystemStoreResourceContainer(metadataUuid, metadataId, metadataUuid, this.settingManager.getNodeURL() + "api/records/", metadataResourceExternalManagementProperties, approved);
        }
        catch (CmisObjectNotFoundException e) {
            return null;
        }
    }

    @Override
    public void copyResources(ServiceContext context, String sourceUuid, String targetUuid, MetadataResourceVisibility metadataResourceVisibility, boolean sourceApproved, boolean targetApproved) throws Exception {
        int sourceMetadataId = this.canEdit(context, sourceUuid, metadataResourceVisibility, sourceApproved);
        String sourceResourceTypeDir = this.getMetadataDir(context, sourceMetadataId) + this.cmisConfiguration.getFolderDelimiter() + metadataResourceVisibility.toString();
        try {
            Folder sourceParentFolder = (Folder)this.cmisConfiguration.getClient().getObjectByPath(sourceResourceTypeDir);
            Map<String, Document> sourceDocumentMap = this.cmisUtils.getCmisObjectMap(sourceParentFolder, null);
            for (Map.Entry<String, Document> sourceEntry : sourceDocumentMap.entrySet()) {
                Document sourceDocument = sourceEntry.getValue();
                Map<String, Object> sourceProperties = this.getSecondaryProperties(sourceDocument);
                this.putResource(context, targetUuid, sourceDocument.getName(), sourceDocument.getContentStream().getStream(), null, metadataResourceVisibility, targetApproved, sourceProperties);
            }
        }
        catch (CmisObjectNotFoundException e) {
            Log.warning((String)("Cannot find folder object from CMIS ... Abort copping resources from " + sourceResourceTypeDir), (Object)((Object)e));
        }
    }

    private Map<String, Object> getSecondaryProperties(Document document) {
        String aspectId = null;
        Property aspectProperty = document.getProperty("cmis:secondaryObjectTypeIds");
        if (aspectProperty != null) {
            aspectId = aspectProperty.getValueAsString();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((Object)aspectId)) {
            for (Property property : document.getProperties()) {
                if (!property.getId().startsWith(aspectId) || property.getValue() == null) continue;
                properties.put(property.getId(), property.getValue());
            }
        }
        return properties;
    }

    private String getMetadataDir(ServiceContext context, int metadataId) {
        Path metadataFullDir = Lib.resource.getMetadataDir(this.getDataDirectory(context), metadataId);
        Path baseMetadataDir = this.getBaseMetadataDir(context, metadataFullDir);
        Path metadataDir = baseMetadataDir.toString().equals(".") ? Paths.get(this.cmisConfiguration.getBaseRepositoryPath(), new String[0]).resolve(metadataFullDir) : Paths.get(this.cmisConfiguration.getBaseRepositoryPath(), new String[0]).resolve(baseMetadataDir.relativize(metadataFullDir));
        if (metadataDir.getFileSystem().getSeparator().equals(this.cmisConfiguration.getFolderDelimiter())) {
            return metadataDir.toString();
        }
        return metadataDir.toString().replace(metadataDir.getFileSystem().getSeparator(), this.cmisConfiguration.getFolderDelimiter());
    }

    private Path getBaseMetadataDir(ServiceContext context, Path metadataFullDir) {
        if (this.baseMetadataDir == null) {
            Path systemFullDir = this.getDataDirectory(context).getSystemDataDir();
            this.baseMetadataDir = metadataFullDir.toString().startsWith(systemFullDir.toString()) ? systemFullDir : (this.getDataDirectory(context).getMetadataDataDir().isAbsolute() ? metadataFullDir.getRoot() : Paths.get(".", new String[0]));
        }
        return this.baseMetadataDir;
    }

    private GeonetworkDataDirectory getDataDirectory(ServiceContext context) {
        return context.getBean(GeonetworkDataDirectory.class);
    }

    private MetadataResourceExternalManagementProperties getMetadataResourceExternalManagementProperties(ServiceContext context, int metadataId, String metadataUuid, MetadataResourceVisibility visibility, String resourceId, String filename, String version, String cmisObjectId, ObjectType type) {
        String metadataResourceExternalManagementPropertiesUrl = this.cmisConfiguration.getExternalResourceManagementUrl();
        if (!StringUtils.isEmpty((Object)metadataResourceExternalManagementPropertiesUrl)) {
            if (metadataResourceExternalManagementPropertiesUrl.contains("{id}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{id\\})", resourceId == null ? "" : resourceId);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{type:")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("\\{type:([a-zA-Z0-9]*?):([a-zA-Z0-9]*?)\\}", type == null ? "" : (type instanceof Folder ? "$1" : "$2"));
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{uuid}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{uuid\\})", metadataUuid == null ? "" : metadataUuid);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{metadataid}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{metadataid\\})", String.valueOf(metadataId));
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{visibility}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{visibility\\})", visibility == null ? "" : visibility.toString().toLowerCase());
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{filename}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{filename\\})", filename == null ? "" : filename);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{version}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{version\\})", version == null ? "" : version);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{cmisobjectid}")) {
                metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{cmisobjectid\\})", cmisObjectId == null ? "" : cmisObjectId);
            }
            if (metadataResourceExternalManagementPropertiesUrl.contains("{lang}") || metadataResourceExternalManagementPropertiesUrl.contains("{ISO3lang}")) {
                String iso3Lang;
                String lang;
                String contextLang;
                IsoLanguagesMapper mapper = (IsoLanguagesMapper)ApplicationContextHolder.get().getBean(IsoLanguagesMapper.class);
                String string = contextLang = context.getLanguage() == null ? "eng" : context.getLanguage();
                if (contextLang.length() == 2) {
                    lang = contextLang;
                    iso3Lang = mapper.iso639_1_to_iso639_2(contextLang);
                } else {
                    lang = mapper.iso639_2_to_iso639_1(contextLang);
                    iso3Lang = contextLang;
                }
                if (metadataResourceExternalManagementPropertiesUrl.contains("{lang}")) {
                    metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{lang\\})", lang);
                }
                if (metadataResourceExternalManagementPropertiesUrl.contains("{iso3lang}")) {
                    metadataResourceExternalManagementPropertiesUrl = metadataResourceExternalManagementPropertiesUrl.replaceAll("(\\{iso3lang\\})", iso3Lang);
                }
            }
        }
        MetadataResourceExternalManagementProperties metadataResourceExternalManagementProperties = new MetadataResourceExternalManagementProperties(cmisObjectId, metadataResourceExternalManagementPropertiesUrl);
        return metadataResourceExternalManagementProperties;
    }

    @Override
    public Store.ResourceManagementExternalProperties getResourceManagementExternalProperties() {
        return new Store.ResourceManagementExternalProperties(){

            @Override
            public boolean isEnabled() {
                return !StringUtils.isEmpty((Object)CMISStore.this.cmisConfiguration.getExternalResourceManagementUrl());
            }

            @Override
            public String getWindowParameters() {
                return CMISStore.this.cmisConfiguration.getExternalResourceManagementWindowParameters();
            }

            @Override
            public boolean isModal() {
                return CMISStore.this.cmisConfiguration.isExternalResourceManagementModalEnabled();
            }

            @Override
            public boolean isFolderEnabled() {
                return this.isEnabled() && CMISStore.this.cmisConfiguration.isExternalResourceManagementFolderEnabled() != false;
            }

            public String toString() {
                try {
                    return new ObjectMapper().writeValueAsString((Object)this);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Error converting ResourceManagementExternalProperties to json", e);
                }
            }
        };
    }

    private static class ResourceHolderImpl
    implements Store.ResourceHolder {
        private CmisObject cmisObject;
        private Path tempFolderPath;
        private Path path;
        private final MetadataResource metadataResource;

        public ResourceHolderImpl(CmisObject cmisObject, MetadataResource metadataResource) throws IOException {
            this.tempFolderPath = Files.createTempDirectory("gn-meta-res-" + String.valueOf(metadataResource.getMetadataId() + "-"), new FileAttribute[0]);
            this.tempFolderPath.toFile().deleteOnExit();
            this.path = this.tempFolderPath.resolve(CMISStore.getFilename(cmisObject.getName()));
            this.metadataResource = metadataResource;
            this.cmisObject = cmisObject;
            try (InputStream in = ((Document)cmisObject).getContentStream().getStream();){
                Files.copy(in, this.path, StandardCopyOption.REPLACE_EXISTING);
            }
        }

        @Override
        public Path getPath() {
            return this.path;
        }

        public CmisObject getCmisObject() {
            return this.cmisObject;
        }

        @Override
        public MetadataResource getMetadata() {
            return this.metadataResource;
        }

        @Override
        public void close() throws IOException {
            IO.deleteFileOrDirectory((Path)this.tempFolderPath, (boolean)true);
            this.path = null;
            this.tempFolderPath = null;
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

