/*
 * Decompiled with CFR 0.152.
 */
package jeeves.services.http;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Path;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class Get
implements Service {
    public static final String URL_PARAM_NAME = "url";
    private String configUrl;

    @Override
    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.configUrl = params.getValue(URL_PARAM_NAME);
    }

    @Override
    public Element exec(Element params, ServiceContext context) throws Exception {
        String sUrl = params.getChildText(URL_PARAM_NAME);
        if (sUrl == null) {
            sUrl = this.configUrl;
        }
        if (sUrl == null) {
            throw new IllegalArgumentException("The 'url' configuration parameter is missing");
        }
        boolean first = new URL(sUrl).getQuery() == null;
        StringBuffer sb = new StringBuffer(sUrl);
        for (Element child : params.getChildren()) {
            if (child.getName().equals(URL_PARAM_NAME)) continue;
            if (first) {
                first = false;
                sb.append('?');
            } else {
                sb.append('&');
            }
            sb.append(child.getName()).append('=').append(URLEncoder.encode(child.getText(), Constants.ENCODING));
        }
        URL url = new URL(sb.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        InputStream input = conn.getInputStream();
        return Xml.loadStream((InputStream)input);
    }
}

