/*
 * Decompiled with CFR 0.152.
 */
package jeeves.services;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class RegExpReplace
implements Service {
    private Vector<Pattern> patterns;
    private Vector<String> replacements;

    @Override
    public void init(Path appPath, ServiceConfig params) throws Exception {
        String file = params.getMandatoryValue("file");
        Element config = Xml.loadFile((Path)appPath.resolve(file));
        this.patterns = new Vector();
        this.replacements = new Vector();
        for (Element expr : config.getChildren()) {
            String pattern = expr.getAttributeValue("pattern");
            String replacement = expr.getAttributeValue("replacement");
            this.patterns.add(Pattern.compile(pattern));
            this.replacements.add(this.getRealText(replacement));
        }
    }

    @Override
    public Element exec(Element params, ServiceContext context) throws Exception {
        this.replaceInElement(params);
        return params;
    }

    private String getRealText(String text) {
        String noLt = this.replace(text, "&lt;", "<");
        String noGt = this.replace(noLt, "&gt;", ">");
        String noAmp = this.replace(noGt, "&amp;", "&");
        return noAmp;
    }

    private String replace(String text, String delim, String replacement) {
        StringBuffer result = new StringBuffer();
        StringTokenizer st = new StringTokenizer(text, delim, true);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(delim)) {
                result.append(replacement);
                continue;
            }
            result.append(token);
        }
        return result.toString();
    }

    private void replaceInElement(Element e) {
        if (e.getChildren().size() != 0) {
            Iterator iter = e.getChildren().iterator();
            while (iter.hasNext()) {
                this.replaceInElement((Element)iter.next());
            }
        } else {
            String text = e.getText();
            for (int i = 0; i < this.patterns.size(); ++i) {
                Pattern pattern = this.patterns.get(i);
                String replacement = this.replacements.get(i);
                Matcher matcher = pattern.matcher(text);
                text = matcher.replaceAll(replacement);
            }
            e.setText(text);
        }
    }
}

