/*
 * Decompiled with CFR 0.152.
 */
package jeeves.monitor.healthcheck;

import com.sun.management.UnixOperatingSystemMXBean;
import com.yammer.metrics.core.HealthCheck;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;

public class FreeFileHandlesHealthCheck
implements HealthCheckFactory {
    @Override
    public HealthCheck create(ServiceContext context) {
        return new HealthCheck("Free file handles"){

            protected HealthCheck.Result check() throws Exception {
                try {
                    double fivePercent;
                    UnixOperatingSystemMXBean unixMXBean;
                    long free;
                    OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
                    if (osMbean instanceof UnixOperatingSystemMXBean && (double)(free = (unixMXBean = (UnixOperatingSystemMXBean)osMbean).getMaxFileDescriptorCount() - unixMXBean.getOpenFileDescriptorCount()) < (fivePercent = Math.max(2.0, (double)unixMXBean.getMaxFileDescriptorCount() * 0.01))) {
                        return HealthCheck.Result.unhealthy((String)("There are insufficient free file handles. Connections free:" + free));
                    }
                    return HealthCheck.Result.healthy();
                }
                catch (Exception e) {
                    return HealthCheck.Result.unhealthy((Throwable)e);
                }
            }
        };
    }
}

