/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jclouds.ultradns.ws.domain.TrafficControllerPool;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;

public class TrafficControllerPoolPredicates {
    public static Predicate<TrafficControllerPool> idEqualTo(String id) {
        return new IdEqualToPredicate(id);
    }

    public static Predicate<TrafficControllerPoolRecordDetail> recordIdEqualTo(String recordId) {
        return new RecordIdEqualToPredicate(recordId);
    }

    private static final class RecordIdEqualToPredicate
    implements Predicate<TrafficControllerPoolRecordDetail> {
        private final String recordId;

        public RecordIdEqualToPredicate(String recordId) {
            this.recordId = (String)Preconditions.checkNotNull((Object)recordId, (Object)"recordId");
        }

        public boolean apply(TrafficControllerPoolRecordDetail input) {
            return input != null && this.recordId.equals(input.getId());
        }

        public String toString() {
            return "RecordIdEqualTo(" + this.recordId + ")";
        }
    }

    private static final class IdEqualToPredicate
    implements Predicate<TrafficControllerPool> {
        private final String id;

        public IdEqualToPredicate(String id) {
            this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        }

        public boolean apply(TrafficControllerPool input) {
            return input != null && this.id.equals(input.getId());
        }

        public String toString() {
            return "IdEqualTo(" + this.id + ")";
        }
    }
}

