/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.CQLString;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jzkit.search.util.QueryModel.CQLString.CQLString;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.springframework.context.ApplicationContext;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLRelation;
import org.z3950.zing.cql.CQLTermNode;

public class CQLBuilder {
    private static Log log = LogFactory.getLog(CQLBuilder.class);

    public static CQLString buildFrom(QueryModel model, ApplicationContext ctx) throws InvalidQueryException {
        InternalModelRootNode root = model.toInternalQueryModel(ctx);
        return new CQLString(CQLBuilder.visitNode(root, null, null, false));
    }

    public static CQLString buildFrom(QueryModel model, ApplicationContext ctx, boolean complex_support) throws InvalidQueryException {
        InternalModelRootNode root = model.toInternalQueryModel(ctx);
        return new CQLString(CQLBuilder.visitNode(root, null, null, complex_support));
    }

    public static CQLNode visitNode(QueryNode node, String source_ns, String target_ns, boolean complex_support) {
        log.debug((Object)"visitNode");
        Object result = null;
        if (node instanceof InternalModelRootNode) {
            log.debug((Object)"Processing root");
            result = CQLBuilder.visitNode(((InternalModelRootNode)node).getChild(), source_ns, target_ns, complex_support);
        } else if (node instanceof InternalModelNamespaceNode) {
            log.debug((Object)("Processing namespace: " + node));
            InternalModelNamespaceNode ns_node = (InternalModelNamespaceNode)node;
            result = complex_support ? new CQLPrefixNode(ns_node.getAttrset(), ns_node.getAttrset(), CQLBuilder.visitNode(ns_node.getChild(), ns_node.getAttrset(), target_ns, complex_support)) : CQLBuilder.visitNode(ns_node.getChild(), ns_node.getAttrset(), target_ns, complex_support);
        } else if (node instanceof ComplexNode) {
            log.debug((Object)"Processing complex");
            switch (((ComplexNode)node).getOp()) {
                case 1: {
                    result = new CQLAndNode(CQLBuilder.visitNode(((ComplexNode)node).getLHS(), source_ns, target_ns, complex_support), CQLBuilder.visitNode(((ComplexNode)node).getRHS(), source_ns, target_ns, complex_support));
                    break;
                }
                case 2: {
                    result = new CQLOrNode(CQLBuilder.visitNode(((ComplexNode)node).getLHS(), source_ns, target_ns, complex_support), CQLBuilder.visitNode(((ComplexNode)node).getRHS(), source_ns, target_ns, complex_support));
                    break;
                }
                case 3: {
                    result = new CQLNotNode(CQLBuilder.visitNode(((ComplexNode)node).getLHS(), source_ns, target_ns, complex_support), CQLBuilder.visitNode(((ComplexNode)node).getRHS(), source_ns, target_ns, complex_support));
                    break;
                }
                default: {
                    log.warn((Object)"Prox not yet handled");
                    break;
                }
            }
        } else if (node instanceof AttrPlusTermNode) {
            AttrPlusTermNode aptn = (AttrPlusTermNode)node;
            log.debug((Object)("Processing attrplustermnode:" + node));
            CQLRelation relation = null;
            relation = aptn.getRelation() != null ? new CQLRelation(aptn.getRelation().toString()) : new CQLRelation("=");
            String qualifier = null;
            Object ap_node = aptn.getAccessPoint();
            if (ap_node != null) {
                qualifier = ap_node.toString();
            }
            result = new CQLTermNode(qualifier, relation, aptn.getTerm().toString());
        }
        return result;
    }
}

