/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.domain;

import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v3.domain.Group;
import org.jclouds.openstack.keystone.v3.domain.Link;

final class AutoValue_Group
extends Group {
    private final String id;
    private final String name;
    private final String description;
    private final String domainId;
    private final Link link;

    private AutoValue_Group(String id, String name, @Nullable String description, @Nullable String domainId, @Nullable Link link) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.domainId = domainId;
        this.link = link;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public String domainId() {
        return this.domainId;
    }

    @Override
    @Nullable
    public Link link() {
        return this.link;
    }

    public String toString() {
        return "Group{id=" + this.id + ", " + "name=" + this.name + ", " + "description=" + this.description + ", " + "domainId=" + this.domainId + ", " + "link=" + this.link + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Group) {
            Group that = (Group)o;
            return this.id.equals(that.id()) && this.name.equals(that.name()) && (this.description == null ? that.description() == null : this.description.equals(that.description())) && (this.domainId == null ? that.domainId() == null : this.domainId.equals(that.domainId())) && (this.link == null ? that.link() == null : this.link.equals(that.link()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.id.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.description == null ? 0 : this.description.hashCode();
        h *= 1000003;
        h ^= this.domainId == null ? 0 : this.domainId.hashCode();
        h *= 1000003;
        return h ^= this.link == null ? 0 : this.link.hashCode();
    }

    @Override
    public Group.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends Group.Builder {
        private String id;
        private String name;
        private String description;
        private String domainId;
        private Link link;

        Builder() {
        }

        private Builder(Group source) {
            this.id = source.id();
            this.name = source.name();
            this.description = source.description();
            this.domainId = source.domainId();
            this.link = source.link();
        }

        @Override
        public Group.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public Group.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public Group.Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public Group.Builder domainId(@Nullable String domainId) {
            this.domainId = domainId;
            return this;
        }

        @Override
        public Group.Builder link(@Nullable Link link) {
            this.link = link;
            return this;
        }

        @Override
        public Group build() {
            String missing = "";
            if (this.id == null) {
                missing = missing + " id";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_Group(this.id, this.name, this.description, this.domainId, this.link);
        }
    }
}

