/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils.debug;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.fao.geonet.Constants;
import org.fao.geonet.utils.Log;

public class OpenResourceTracker
extends RuntimeException {
    private static Multimap<String, OpenResourceTracker> openResources = HashMultimap.create();
    private static Map<Integer, Boolean> reports = Maps.newHashMap();

    public static synchronized void open(String descriptor, OpenResourceTracker openStackTrace) throws IOException {
        openResources.put((Object)descriptor, (Object)openStackTrace);
        OpenResourceTracker.reportOpenResources(1000);
        OpenResourceTracker.reportOpenResources(2000);
        OpenResourceTracker.reportOpenResources(3000);
        OpenResourceTracker.reportOpenResources(4000);
    }

    public static void reportOpenResources(int cutOff) throws IOException {
        if (openResources.size() > cutOff && !OpenResourceTracker.isReported(cutOff)) {
            OpenResourceTracker.printExceptions(100);
        }
    }

    private static boolean isReported(Integer numOpenResources) {
        if (reports.containsKey(numOpenResources)) {
            return reports.get(numOpenResources);
        }
        return false;
    }

    public static synchronized void close(String descriptor, OpenResourceTracker openStackTrace) {
        openResources.remove((Object)descriptor, (Object)openStackTrace);
    }

    public static synchronized void printExceptions(int numExceptionsToPrint) throws IOException {
        Path log = Files.createTempFile("openFileTraces", ".txt", new FileAttribute[0]);
        try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(log, Constants.CHARSET, new OpenOption[0]));){
            OpenResourceTracker.printExceptions(out, numExceptionsToPrint);
        }
        String message = "Resource Leak detected: First " + numExceptionsToPrint + " of " + openResources.size() + " open file stacktraces to: " + log;
        Log.error("jeeves", message);
    }

    public static synchronized void printExceptions(PrintWriter out, int numExceptionsToPrint) throws IOException {
        int count = 0;
        for (Map.Entry entry : openResources.entries()) {
            if (count >= numExceptionsToPrint) {
                return;
            }
            out.println((String)entry.getKey());
            ((OpenResourceTracker)entry.getValue()).printStackTrace(out);
            ++count;
        }
    }

    public static int numberOfOpenResources() {
        return openResources.size();
    }
}

