/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.fao.geonet.exceptions.BadServerResponseEx;
import org.fao.geonet.exceptions.BadSoapResponseEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.utils.AbstractHttpRequest;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.http.client.ClientHttpResponse;

public class XmlRequest
extends AbstractHttpRequest {
    XmlRequest(String host, int port, String protocol, GeonetHttpRequestFactory requestFactory) {
        super(protocol, host, port, requestFactory);
        this.setMethod(AbstractHttpRequest.Method.GET);
    }

    public final Element execute(Element request) throws IOException, BadXmlResponseEx, BadSoapResponseEx {
        this.setRequest(request);
        return this.execute();
    }

    public final Element execute() throws IOException, BadXmlResponseEx, BadSoapResponseEx {
        HttpRequestBase httpMethod = this.setupHttpMethod();
        Element response = this.executeAndReadResponse(httpMethod);
        if (this.useSOAP) {
            response = this.soapUnembed(response);
        }
        return response;
    }

    public final void executeLarge(Path outFile) throws IOException {
        HttpRequestBase httpMethod = this.setupHttpMethod();
        this.doExecuteLarge(httpMethod, outFile);
    }

    protected final Element executeAndReadResponse(HttpRequestBase httpMethod) throws IOException, BadXmlResponseEx {
        ClientHttpResponse httpResponse = this.doExecute(httpMethod);
        if (httpResponse.getRawStatusCode() > 399) {
            httpMethod.releaseConnection();
            throw new BadServerResponseEx((Object)(httpResponse.getStatusText() + " -- URI: " + httpMethod.getURI() + " -- Response Code: " + httpResponse.getRawStatusCode()));
        }
        byte[] data = null;
        try {
            data = IOUtils.toByteArray((InputStream)httpResponse.getBody());
            Element element = Xml.loadStream(new ByteArrayInputStream(data));
            return element;
        }
        catch (JDOMException e) {
            throw new BadXmlResponseEx("Response: '" + new String(data, "UTF8") + "' (from URI " + httpMethod.getURI() + ")");
        }
        finally {
            httpMethod.releaseConnection();
            this.sentData = this.getSentData(httpMethod);
        }
    }

    /*
     * Loose catch block
     */
    protected final Path doExecuteLarge(HttpRequestBase httpMethod, Path outFile) throws IOException {
        try {
            try (ClientHttpResponse httpResponse = this.doExecute(httpMethod);){
                Files.copy(httpResponse.getBody(), outFile, StandardCopyOption.REPLACE_EXISTING);
                Path path = outFile;
                return path;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpMethod.releaseConnection();
            this.sentData = this.getSentData(httpMethod);
        }
    }
}

