/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import org.geotools.data.postgis.PostGISDialect;
import org.geotools.util.Version;
import org.opengis.feature.type.GeometryDescriptor;

public class GeometryColumnEncoder {
    private final boolean atLeast2_2_0;
    private final boolean stSimplifyEnabled;
    private final boolean encodeBase64;
    private final PostGISDialect dialect;

    GeometryColumnEncoder(Version version, boolean stSimplifyEnabled, boolean encodeBase64, PostGISDialect dialect) {
        this.atLeast2_2_0 = version != null && version.compareTo(PostGISDialect.V_2_2_0) >= 0;
        this.stSimplifyEnabled = stSimplifyEnabled;
        this.encodeBase64 = encodeBase64;
        this.dialect = dialect;
    }

    public void encode(GeometryDescriptor gatt, String prefix, StringBuffer sql, boolean force2D, Double distance) {
        if (this.encodeBase64) {
            sql.append("encode(");
        }
        if (distance == null) {
            this.encodeNotSimplified(gatt, prefix, sql, force2D);
        } else {
            this.encodeSimplified(gatt, prefix, sql, force2D, distance);
        }
        if (this.encodeBase64) {
            sql.append(", 'base64')");
        }
    }

    private void encodeNotSimplified(GeometryDescriptor gatt, String prefix, StringBuffer sql, boolean force2D) {
        boolean geography = "geography".equals(gatt.getUserData().get("org.geotools.jdbc.nativeTypeName"));
        if (geography) {
            this.encodeGeography(gatt, prefix, sql);
        } else if (force2D) {
            sql.append("ST_AsBinary(");
            this.dialect.encodeColumnName(prefix, gatt.getLocalName(), sql);
            sql.append(")");
        } else {
            sql.append("ST_AsEWKB(");
            this.dialect.encodeColumnName(prefix, gatt.getLocalName(), sql);
            sql.append(")");
        }
    }

    private void encodeGeography(GeometryDescriptor gatt, String prefix, StringBuffer sql) {
        sql.append("ST_AsBinary(");
        this.dialect.encodeColumnName(prefix, gatt.getLocalName(), sql);
        sql.append(")");
    }

    private void encodeSimplified(GeometryDescriptor gatt, String prefix, StringBuffer sql, boolean force2D, double distance) {
        boolean geography = "geography".equals(gatt.getUserData().get("org.geotools.jdbc.nativeTypeName"));
        if (geography) {
            this.encodeGeography(gatt, prefix, sql);
            return;
        }
        if (this.dialect.isStraightSegmentsGeometry(gatt)) {
            if (this.atLeast2_2_0) {
                sql.append("ST_AsTWKB(");
                this.encode2DGeometry(gatt, prefix, sql, this.stSimplifyEnabled ? Double.valueOf(distance) : null);
                sql.append("," + this.getTWKBDigits(distance) + ")");
            } else {
                sql.append("ST_AsBinary(");
                this.encode2DGeometry(gatt, prefix, sql, this.stSimplifyEnabled ? Double.valueOf(distance) : null);
                sql.append(")");
            }
        } else {
            sql.append("ST_AsBinary(");
            sql.append("CASE WHEN ST_HasArc(");
            this.dialect.encodeColumnName(prefix, gatt.getLocalName(), sql);
            sql.append(") THEN ");
            this.dialect.encodeColumnName(prefix, gatt.getLocalName(), sql);
            sql.append(" ELSE ");
            this.encode2DGeometry(gatt, prefix, sql, distance);
            sql.append(" END)");
        }
    }

    private void encode2DGeometry(GeometryDescriptor gatt, String prefix, StringBuffer sql, Double distance) {
        if (distance != null) {
            sql.append("ST_Simplify(");
        }
        sql.append(this.dialect.getForce2DFunction() + "(");
        this.dialect.encodeColumnName(prefix, gatt.getLocalName(), sql);
        sql.append(")");
        if (distance != null) {
            String preserveCollapsed = this.atLeast2_2_0 ? ", true" : "";
            sql.append(", " + distance + preserveCollapsed + ")");
        }
    }

    private int getTWKBDigits(Double distance) {
        int result = -((int)Math.floor(Math.log10(distance)));
        return result;
    }
}

