/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.problems;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ProblemsPrinter;

public class BugHappened
extends RuntimeException {
    private static final String PREFIX = "Bug, please report issue: ";

    public BugHappened(String message, HiddenTokenAwareTree offendingNode) {
        super(PREFIX + message + BugHappened.errorPlace(offendingNode));
    }

    public BugHappened(String message, ASTCssNode offendingNode) {
        super(PREFIX + message + BugHappened.errorPlace(offendingNode));
    }

    public BugHappened(Throwable th, ASTCssNode object) {
        super(PREFIX + BugHappened.errorPlace(object), th);
    }

    private static String errorPlace(ASTCssNode offendingNode) {
        if (offendingNode == null) {
            return "";
        }
        ProblemsPrinter.AbsoluteSourceNamePrinter printer = new ProblemsPrinter.AbsoluteSourceNamePrinter();
        String filename = printer.printSourceName(offendingNode.getSource());
        return "\n Offending place: " + filename + " " + offendingNode.getSourceLine() + ":" + offendingNode.getSourceColumn();
    }

    private static String errorPlace(HiddenTokenAwareTree offendingNode) {
        if (offendingNode == null) {
            return "";
        }
        ProblemsPrinter.AbsoluteSourceNamePrinter printer = new ProblemsPrinter.AbsoluteSourceNamePrinter();
        String filename = printer.printSourceName(offendingNode.getSource());
        return "\n Offending place: " + filename + " " + offendingNode.getLine() + ":" + (offendingNode.getCharPositionInLine() + 1);
    }
}

