/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.strategy.internal;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jclouds.chef.ChefApi;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.logging.Logger;

public abstract class BaseListCookbookVersionsImpl {
    protected final ChefApi api;
    protected Logger logger = Logger.NULL;

    BaseListCookbookVersionsImpl(ChefApi api) {
        this.api = (ChefApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Iterable<? extends CookbookVersion> execute(Iterable<String> toGet) {
        return Iterables.concat((Iterable)Iterables.transform(toGet, (Function)new Function<String, Iterable<? extends CookbookVersion>>(){

            public Iterable<? extends CookbookVersion> apply(final String cookbook) {
                Set<String> cookbookVersions = BaseListCookbookVersionsImpl.this.api.listVersionsOfCookbook(cookbook);
                Iterable cookbooksVersions = Iterables.transform(cookbookVersions, (Function)new Function<String, CookbookVersion>(){

                    public CookbookVersion apply(String version) {
                        return BaseListCookbookVersionsImpl.this.api.getCookbook(cookbook, version);
                    }
                });
                BaseListCookbookVersionsImpl.this.logger.trace(String.format("getting versions of cookbook: %s", cookbook), new Object[0]);
                return cookbooksVersions;
            }
        }));
    }

    protected Iterable<? extends CookbookVersion> executeConcurrently(final ListeningExecutorService executor, Iterable<String> cookbookNames) {
        return Iterables.concat((Iterable)Iterables.transform(cookbookNames, (Function)new Function<String, Iterable<? extends CookbookVersion>>(){

            public Iterable<? extends CookbookVersion> apply(final String cookbook) {
                Set<String> cookbookVersions = BaseListCookbookVersionsImpl.this.api.listVersionsOfCookbook(cookbook);
                ListenableFuture futures = Futures.allAsList((Iterable)Iterables.transform(cookbookVersions, (Function)new Function<String, ListenableFuture<CookbookVersion>>(){

                    public ListenableFuture<CookbookVersion> apply(final String version) {
                        return executor.submit((Callable)new Callable<CookbookVersion>(){

                            @Override
                            public CookbookVersion call() throws Exception {
                                return BaseListCookbookVersionsImpl.this.api.getCookbook(cookbook, version);
                            }
                        });
                    }
                }));
                BaseListCookbookVersionsImpl.this.logger.trace(String.format("getting versions of cookbook: %s", cookbook), new Object[0]);
                return (Iterable)Futures.getUnchecked((Future)futures);
            }
        }));
    }
}

