/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.chef.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.chef.domain.DatabagItem;
import org.jclouds.chef.domain.SearchResult;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;

@Singleton
public class ParseSearchDatabagFromJson
implements Function<HttpResponse, SearchResult<DatabagItem>> {
    private final ParseJson<Response> responseParser;
    private final Json json;

    @Inject
    ParseSearchDatabagFromJson(ParseJson<Response> responseParser, Json json) {
        this.responseParser = responseParser;
        this.json = json;
    }

    public SearchResult<DatabagItem> apply(HttpResponse response) {
        Response returnVal = (Response)this.responseParser.apply(response);
        Iterable items = Iterables.transform(returnVal.rows, (Function)new Function<Row, DatabagItem>(){

            public DatabagItem apply(Row input) {
                return (DatabagItem)((Object)ParseSearchDatabagFromJson.this.json.fromJson(input.rawData.toString(), DatabagItem.class));
            }
        });
        return new SearchResult<DatabagItem>(returnVal.start, items);
    }

    static class Response {
        long start;
        List<Row> rows;

        Response() {
        }
    }

    static class Row {
        @SerializedName(value="raw_data")
        JsonBall rawData;

        Row() {
        }
    }
}

