/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate5.encryptor;

import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate5.encryptor.HibernatePBEEncryptorRegistry;
import org.jasypt.iv.IvGenerator;
import org.jasypt.salt.SaltGenerator;

public final class HibernatePBEByteEncryptor {
    private String registeredName = null;
    private PBEByteEncryptor encryptor = null;
    private boolean encryptorSet = false;

    public HibernatePBEByteEncryptor() {
        this.encryptor = new StandardPBEByteEncryptor();
        this.encryptorSet = false;
    }

    HibernatePBEByteEncryptor(String registeredName, PBEByteEncryptor encryptor) {
        this.encryptor = encryptor;
        this.registeredName = registeredName;
        this.encryptorSet = true;
    }

    public PBEByteEncryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(PBEByteEncryptor encryptor) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        this.encryptor = encryptor;
        this.encryptorSet = true;
    }

    public void setPassword(String password) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEByteEncryptor standardPBEByteEncryptor = (StandardPBEByteEncryptor)this.encryptor;
        standardPBEByteEncryptor.setPassword(password);
    }

    public void setPasswordCharArray(char[] password) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEByteEncryptor standardPBEByteEncryptor = (StandardPBEByteEncryptor)this.encryptor;
        standardPBEByteEncryptor.setPasswordCharArray(password);
    }

    public void setAlgorithm(String algorithm) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEByteEncryptor standardPBEByteEncryptor = (StandardPBEByteEncryptor)this.encryptor;
        standardPBEByteEncryptor.setAlgorithm(algorithm);
    }

    public void setKeyObtentionIterations(int keyObtentionIterations) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEByteEncryptor standardPBEByteEncryptor = (StandardPBEByteEncryptor)this.encryptor;
        standardPBEByteEncryptor.setKeyObtentionIterations(keyObtentionIterations);
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEByteEncryptor standardPBEByteEncryptor = (StandardPBEByteEncryptor)this.encryptor;
        standardPBEByteEncryptor.setSaltGenerator(saltGenerator);
    }

    public void setIvGenerator(IvGenerator ivGenerator) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEByteEncryptor standardPBEByteEncryptor = (StandardPBEByteEncryptor)this.encryptor;
        standardPBEByteEncryptor.setIvGenerator(ivGenerator);
    }

    public void setConfig(PBEConfig config) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEByteEncryptor standardPBEByteEncryptor = (StandardPBEByteEncryptor)this.encryptor;
        standardPBEByteEncryptor.setConfig(config);
    }

    public byte[] encrypt(byte[] message) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.encrypt(message);
    }

    public byte[] decrypt(byte[] encryptedMessage) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.decrypt(encryptedMessage);
    }

    public void setRegisteredName(String registeredName) {
        if (this.registeredName != null) {
            HibernatePBEEncryptorRegistry.getInstance().unregisterHibernatePBEByteEncryptor(this.registeredName);
        }
        this.registeredName = registeredName;
        HibernatePBEEncryptorRegistry.getInstance().registerHibernatePBEByteEncryptor(this);
    }

    public String getRegisteredName() {
        return this.registeredName;
    }
}

